/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gitlab;

import com.vladsch.flexmark.ext.gitlab.internal.GitLabBlockQuoteParser;
import com.vladsch.flexmark.ext.gitlab.internal.GitLabInlineMathParser;
import com.vladsch.flexmark.ext.gitlab.internal.GitLabInlineParser;
import com.vladsch.flexmark.ext.gitlab.internal.GitLabNodeFormatter;
import com.vladsch.flexmark.ext.gitlab.internal.GitLabNodeRenderer;
import com.vladsch.flexmark.ext.gitlab.internal.GitLabOptions;
import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.parser.InlineParserExtensionFactory;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import org.jetbrains.annotations.NotNull;

public class GitLabExtension
implements Parser.ParserExtension,
HtmlRenderer.HtmlRendererExtension,
Formatter.FormatterExtension {
    private static final String[] DEFAULT_MATH_LANGUAGES = new String[]{"math"};
    private static final String[] DEFAULT_MERMAID_LANGUAGES = new String[]{"mermaid"};
    public static final DataKey<Boolean> INS_PARSER = new DataKey("INS_PARSER", (Object)true);
    public static final DataKey<Boolean> DEL_PARSER = new DataKey("DEL_PARSER", (Object)true);
    public static final DataKey<Boolean> BLOCK_QUOTE_PARSER = new DataKey("BLOCK_QUOTE_PARSER", (Object)true);
    public static final DataKey<Boolean> NESTED_BLOCK_QUOTES = new DataKey("NESTED_BLOCK_QUOTES", (Object)true);
    public static final DataKey<Boolean> INLINE_MATH_PARSER = new DataKey("INLINE_MATH_PARSER", (Object)true);
    public static final DataKey<Boolean> RENDER_BLOCK_MATH = new DataKey("RENDER_BLOCK_MATH", (Object)true);
    public static final DataKey<Boolean> RENDER_BLOCK_MERMAID = new DataKey("RENDER_BLOCK_MERMAID", (Object)true);
    public static final DataKey<Boolean> RENDER_VIDEO_IMAGES = new DataKey("RENDER_VIDEO_IMAGES", (Object)true);
    public static final DataKey<Boolean> RENDER_VIDEO_LINK = new DataKey("RENDER_VIDEO_LINK", (Object)true);
    public static final DataKey<String[]> MATH_LANGUAGES = new DataKey("MATH_LANGUAGES", (Object)DEFAULT_MATH_LANGUAGES);
    public static final DataKey<String[]> MERMAID_LANGUAGES = new DataKey("MERMAID_LANGUAGES", (Object)DEFAULT_MERMAID_LANGUAGES);
    public static final DataKey<String> INLINE_MATH_CLASS = new DataKey("INLINE_MATH_CLASS", (Object)"katex");
    public static final DataKey<String> BLOCK_MATH_CLASS = new DataKey("BLOCK_MATH_CLASS", (Object)"katex");
    public static final DataKey<String> BLOCK_MERMAID_CLASS = new DataKey("BLOCK_MERMAID_CLASS", (Object)"mermaid");
    public static final DataKey<String> VIDEO_IMAGE_CLASS = new DataKey("VIDEO_IMAGE_CLASS", (Object)"video-container");
    public static final DataKey<String> VIDEO_IMAGE_LINK_TEXT_FORMAT = new DataKey("VIDEO_IMAGE_LINK_TEXT_FORMAT", (Object)"Download '%s'");
    @Deprecated
    public static final DataKey<String> BLOCK_INFO_DELIMITERS = HtmlRenderer.FENCED_CODE_LANGUAGE_DELIMITERS;
    public static final DataKey<String> VIDEO_IMAGE_EXTENSIONS = new DataKey("VIDEO_IMAGE_EXTENSIONS", (Object)"mp4,m4v,mov,webm,ogv");

    private GitLabExtension() {
    }

    public static GitLabExtension create() {
        return new GitLabExtension();
    }

    public void rendererOptions(@NotNull MutableDataHolder options) {
    }

    public void parserOptions(MutableDataHolder options) {
    }

    public void extend(Formatter.Builder formatterBuilder) {
        formatterBuilder.nodeFormatterFactory((NodeFormatterFactory)new GitLabNodeFormatter.Factory());
    }

    public void extend(Parser.Builder parserBuilder) {
        GitLabOptions options = new GitLabOptions((DataHolder)parserBuilder);
        if (options.blockQuoteParser) {
            parserBuilder.customBlockParserFactory((CustomBlockParserFactory)new GitLabBlockQuoteParser.Factory());
        }
        if (options.delParser || options.insParser) {
            parserBuilder.customInlineParserExtensionFactory((InlineParserExtensionFactory)new GitLabInlineParser.Factory());
        }
        if (options.inlineMathParser) {
            parserBuilder.customInlineParserExtensionFactory((InlineParserExtensionFactory)new GitLabInlineMathParser.Factory());
        }
    }

    public void extend(@NotNull HtmlRenderer.Builder htmlRendererBuilder, @NotNull String rendererType) {
        if (htmlRendererBuilder.isRendererType("HTML")) {
            htmlRendererBuilder.nodeRendererFactory((NodeRendererFactory)new GitLabNodeRenderer.Factory());
        } else if (htmlRendererBuilder.isRendererType("JIRA")) {
            // empty if block
        }
    }
}

