/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.footnotes.internal;

import com.vladsch.flexmark.ext.footnotes.Footnote;
import com.vladsch.flexmark.ext.footnotes.FootnoteBlock;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteFormatOptions;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteRepository;
import com.vladsch.flexmark.formatter.CustomNodeFormatter;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.NodeRepositoryFormatter;
import com.vladsch.flexmark.formatter.TranslatingSpanRender;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FootnoteNodeFormatter
extends NodeRepositoryFormatter<FootnoteRepository, FootnoteBlock, Footnote> {
    public static final DataKey<Map<String, String>> FOOTNOTE_TRANSLATION_MAP = new DataKey("FOOTNOTE_TRANSLATION_MAP", new HashMap());
    public static final DataKey<Map<String, String>> FOOTNOTE_UNIQUIFICATION_MAP = new DataKey("FOOTNOTE_UNIQUIFICATION_MAP", new HashMap());
    private final FootnoteFormatOptions options;

    public FootnoteNodeFormatter(DataHolder options) {
        super(options, FOOTNOTE_TRANSLATION_MAP, FOOTNOTE_UNIQUIFICATION_MAP);
        this.options = new FootnoteFormatOptions(options);
    }

    public FootnoteRepository getRepository(DataHolder options) {
        return (FootnoteRepository)((Object)FootnoteExtension.FOOTNOTES.getFrom(options));
    }

    public ElementPlacement getReferencePlacement() {
        return this.options.footnotePlacement;
    }

    public ElementPlacementSort getReferenceSort() {
        return this.options.footnoteSort;
    }

    public void renderReferenceBlock(FootnoteBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        ((MarkdownWriter)markdown.blankLine()).append((CharSequence)"[^");
        markdown.append((CharSequence)this.transformReferenceId(node.getText().toString(), context));
        markdown.append((CharSequence)"]: ");
        ((MarkdownWriter)markdown.pushPrefix()).addPrefix((CharSequence)"    ");
        context.renderChildren((Node)node);
        markdown.popPrefix();
        markdown.blankLine();
    }

    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler(Footnote.class, (CustomNodeFormatter)new CustomNodeFormatter<Footnote>(){

            public void render(Footnote node, NodeFormatterContext context, MarkdownWriter markdown) {
                FootnoteNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(FootnoteBlock.class, (CustomNodeFormatter)new CustomNodeFormatter<FootnoteBlock>(){

            public void render(FootnoteBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
                FootnoteNodeFormatter.this.render(node, context, markdown);
            }
        })));
    }

    public Set<Class<?>> getNodeClasses() {
        if (this.options.footnotePlacement != ElementPlacement.AS_IS && this.options.footnoteSort != ElementPlacementSort.SORT_UNUSED_LAST) {
            return null;
        }
        return new HashSet(Arrays.asList(Footnote.class));
    }

    private void render(FootnoteBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.renderReference((Node)node, context, markdown);
    }

    private void render(Footnote node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append((CharSequence)"[^");
        if (context.isTransformingText()) {
            final String referenceId = this.transformReferenceId(node.getText().toString(), context);
            context.nonTranslatingSpan(new TranslatingSpanRender(){

                public void render(NodeFormatterContext context, MarkdownWriter markdown) {
                    markdown.append((CharSequence)referenceId);
                }
            });
        } else {
            markdown.append((CharSequence)node.getText());
        }
        markdown.append((CharSequence)"]");
    }

    public static class Factory
    implements NodeFormatterFactory {
        public NodeFormatter create(DataHolder options) {
            return new FootnoteNodeFormatter(options);
        }
    }
}

