/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.footnotes;

import com.vladsch.flexmark.ast.CustomBlock;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class FootnoteBlock
extends CustomBlock {
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence text = BasedSequence.NULL;
    protected BasedSequence closingMarker = BasedSequence.NULL;
    protected BasedSequence footnote = BasedSequence.NULL;
    private int footnoteOrdinal = 0;
    private int firstReferenceOffset = Integer.MAX_VALUE;

    public int getFirstReferenceOffset() {
        return this.firstReferenceOffset;
    }

    public void setFirstReferenceOffset(int firstReferenceOffset) {
        this.firstReferenceOffset = firstReferenceOffset;
    }

    public void addFirstReferenceOffset(int firstReferenceOffset) {
        if (this.firstReferenceOffset < firstReferenceOffset) {
            this.firstReferenceOffset = firstReferenceOffset;
        }
    }

    public boolean isReferenced() {
        return this.firstReferenceOffset < Integer.MAX_VALUE;
    }

    public int getFootnoteOrdinal() {
        return this.footnoteOrdinal;
    }

    public void setFootnoteOrdinal(int footnoteOrdinal) {
        this.footnoteOrdinal = footnoteOrdinal;
    }

    public void getAstExtra(StringBuilder out) {
        out.append(" ordinal: " + this.footnoteOrdinal + " ");
        FootnoteBlock.segmentSpan((StringBuilder)out, (BasedSequence)this.openingMarker, (String)"open");
        FootnoteBlock.segmentSpan((StringBuilder)out, (BasedSequence)this.text, (String)"text");
        FootnoteBlock.segmentSpan((StringBuilder)out, (BasedSequence)this.closingMarker, (String)"close");
        FootnoteBlock.segmentSpan((StringBuilder)out, (BasedSequence)this.footnote, (String)"footnote");
    }

    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.openingMarker, this.text, this.closingMarker, this.footnote};
    }

    public FootnoteBlock() {
    }

    public FootnoteBlock(BasedSequence chars) {
        super(chars);
    }

    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker;
    }

    public BasedSequence getText() {
        return this.text;
    }

    public void setText(BasedSequence text) {
        this.text = text;
    }

    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }

    public void setClosingMarker(BasedSequence closingMarker) {
        this.closingMarker = closingMarker;
    }

    public BasedSequence getFootnote() {
        return this.footnote;
    }

    public void setFootnote(BasedSequence footnote) {
        this.footnote = footnote;
    }
}

