/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.attributes.internal;

import com.vladsch.flexmark.ext.attributes.AttributeNode;
import com.vladsch.flexmark.ext.attributes.AttributesDelimiter;
import com.vladsch.flexmark.ext.attributes.AttributesNode;
import com.vladsch.flexmark.formatter.CustomNodeFormatter;
import com.vladsch.flexmark.formatter.FormattingPhase;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.PhasedNodeFormatter;
import com.vladsch.flexmark.formatter.RenderPurpose;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AttributesNodeFormatter
implements PhasedNodeFormatter {
    public static final DataKey<Map<String, String>> ATTRIBUTE_TRANSLATION_MAP = new DataKey("ATTRIBUTE_TRANSLATION_MAP", new HashMap());
    public static final DataKey<Map<String, String>> ATTRIBUTE_TRANSLATED_MAP = new DataKey("ATTRIBUTE_TRANSLATED_MAP", new HashMap());
    public static final DataKey<Map<String, String>> ATTRIBUTE_ORIGINAL_ID_MAP = new DataKey("ATTRIBUTE_ORIGINAL_ID_MAP", new HashMap());
    public static final DataKey<Integer> ATTRIBUTE_TRANSLATION_ID = new DataKey("ATTRIBUTE_TRANSLATION_ID", (Object)0);
    private Map<String, String> attributeTranslationMap;
    private Map<String, String> attributeTranslatedMap;
    private Map<String, String> attributeOriginalIdMap;
    private int attributeOriginalId;

    public AttributesNodeFormatter(DataHolder options) {
    }

    public Set<Class<?>> getNodeClasses() {
        return null;
    }

    public Set<FormattingPhase> getFormattingPhases() {
        return Collections.singleton(FormattingPhase.COLLECT);
    }

    public void renderDocument(NodeFormatterContext context, MarkdownWriter markdown, Document document, FormattingPhase phase) {
        if (context.isTransformingText()) {
            if (context.getRenderPurpose() == RenderPurpose.TRANSLATION_SPANS) {
                context.getTranslationStore().set(ATTRIBUTE_TRANSLATION_MAP, new HashMap());
                context.getTranslationStore().set(ATTRIBUTE_TRANSLATED_MAP, new HashMap());
                context.getTranslationStore().set(ATTRIBUTE_ORIGINAL_ID_MAP, new HashMap());
            }
            context.getTranslationStore().set(ATTRIBUTE_TRANSLATION_ID, (Object)0);
            this.attributeOriginalId = 0;
            this.attributeTranslationMap = (Map)context.getTranslationStore().get(ATTRIBUTE_TRANSLATION_MAP);
            this.attributeTranslatedMap = (Map)context.getTranslationStore().get(ATTRIBUTE_TRANSLATED_MAP);
            this.attributeOriginalIdMap = (Map)context.getTranslationStore().get(ATTRIBUTE_ORIGINAL_ID_MAP);
        }
    }

    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeFormattingHandler(AttributesNode.class, (CustomNodeFormatter)new CustomNodeFormatter<AttributesNode>(){

            public void render(AttributesNode node, NodeFormatterContext context, MarkdownWriter markdown) {
                AttributesNodeFormatter.this.render(node, context, markdown);
            }
        }));
        set.add(new NodeFormattingHandler(AttributesDelimiter.class, (CustomNodeFormatter)new CustomNodeFormatter<AttributesDelimiter>(){

            public void render(AttributesDelimiter node, NodeFormatterContext context, MarkdownWriter markdown) {
                AttributesNodeFormatter.this.render(node, context, markdown);
            }
        }));
        return set;
    }

    public static String getEncodedIdAttribute(String category, String categoryId, NodeFormatterContext context, MarkdownWriter markdown) {
        Map attributeTranslationMap = (Map)context.getTranslationStore().get(ATTRIBUTE_TRANSLATION_MAP);
        Map attributeTranslatedMap = (Map)context.getTranslationStore().get(ATTRIBUTE_TRANSLATED_MAP);
        return AttributesNodeFormatter.getEncodedIdAttribute(category, categoryId, context, markdown, attributeTranslationMap, attributeTranslatedMap);
    }

    private static String getEncodedIdAttribute(String category, String categoryId, NodeFormatterContext context, MarkdownWriter markdown, Map<String, String> attributeTranslationMap, Map<String, String> attributeTranslatedMap) {
        String encodedCategory = category;
        String encodedId = categoryId;
        int placeholderId = (Integer)context.getTranslationStore().get(ATTRIBUTE_TRANSLATION_ID);
        switch (context.getRenderPurpose()) {
            case TRANSLATION_SPANS: {
                if (!attributeTranslationMap.containsKey(category)) {
                    encodedCategory = String.format(context.getFormatterOptions().translationIdFormat, ++placeholderId);
                    attributeTranslationMap.put(category, encodedCategory);
                    attributeTranslatedMap.put(encodedCategory, category);
                } else {
                    encodedCategory = attributeTranslationMap.get(category);
                }
                if (categoryId != null && !attributeTranslationMap.containsKey(categoryId)) {
                    encodedId = String.format(context.getFormatterOptions().translationIdFormat, ++placeholderId);
                    attributeTranslationMap.put(categoryId, encodedId);
                    attributeTranslatedMap.put(encodedId, categoryId);
                    break;
                }
                encodedId = attributeTranslationMap.get(categoryId);
                break;
            }
            case TRANSLATED_SPANS: {
                break;
            }
            case TRANSLATED: {
                encodedCategory = attributeTranslatedMap.get(category);
                if (categoryId == null) break;
                encodedId = attributeTranslatedMap.get(categoryId);
                break;
            }
        }
        context.getTranslationStore().set(ATTRIBUTE_TRANSLATION_ID, (Object)placeholderId);
        if (encodedId == null) {
            return encodedCategory;
        }
        return encodedCategory + ':' + encodedId;
    }

    private String getEncodedOriginalId(String attribute, NodeFormatterContext context) {
        switch (context.getRenderPurpose()) {
            case TRANSLATION_SPANS: {
                String encodedAttribute = "#" + String.format(context.getFormatterOptions().translationIdFormat, ++this.attributeOriginalId);
                this.attributeOriginalIdMap.put(encodedAttribute, attribute);
                return encodedAttribute;
            }
            case TRANSLATED_SPANS: {
                return "#" + String.format(context.getFormatterOptions().translationIdFormat, ++this.attributeOriginalId);
            }
            case TRANSLATED: {
                ++this.attributeOriginalId;
                return this.attributeOriginalIdMap.get(attribute);
            }
        }
        return attribute;
    }

    void render(AttributesNode node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.isTransformingText()) {
            markdown.append((CharSequence)node.getOpeningMarker());
            boolean firstChild = true;
            for (Node child : node.getChildren()) {
                AttributeNode attributeNode = (AttributeNode)child;
                if (!firstChild) {
                    markdown.append(' ');
                }
                if (attributeNode.isId()) {
                    BasedSequence valueChars = attributeNode.getValue();
                    int pos = valueChars.indexOf(':');
                    if (pos == -1) {
                        String encodedOriginal = this.getEncodedOriginalId(attributeNode.getChars().toString(), context);
                        markdown.append((CharSequence)encodedOriginal);
                    } else {
                        String category = ((BasedSequence)valueChars.subSequence(0, pos)).toString();
                        String id = ((BasedSequence)valueChars.subSequence(pos + 1)).toString();
                        String encoded = AttributesNodeFormatter.getEncodedIdAttribute(category, id, context, markdown, this.attributeTranslationMap, this.attributeTranslatedMap);
                        switch (context.getRenderPurpose()) {
                            case TRANSLATION_SPANS: 
                            case TRANSLATED_SPANS: {
                                String encodedAttribute = "#" + encoded;
                                this.attributeOriginalIdMap.put(encodedAttribute, attributeNode.getChars().toString());
                                ((MarkdownWriter)markdown.append('#')).append((CharSequence)encoded);
                                break;
                            }
                            case TRANSLATED: {
                                String encodedOriginal = this.attributeOriginalIdMap.get("#" + valueChars.toString());
                                markdown.append((CharSequence)(encodedOriginal == null ? attributeNode.getChars().toString() : encodedOriginal));
                                break;
                            }
                            default: {
                                markdown.append((CharSequence)attributeNode.getChars());
                            }
                        }
                    }
                } else {
                    markdown.appendNonTranslating((CharSequence)".", (CharSequence)attributeNode.getChars());
                }
                firstChild = false;
            }
            markdown.append((CharSequence)node.getClosingMarker());
        } else {
            markdown.append((CharSequence)node.getChars());
        }
    }

    public static class Factory
    implements NodeFormatterFactory {
        public NodeFormatter create(DataHolder options) {
            return new AttributesNodeFormatter(options);
        }
    }
}

