/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.attributes.internal;

import com.vladsch.flexmark.ast.AnchorRefTarget;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ext.attributes.AttributeNode;
import com.vladsch.flexmark.ext.attributes.AttributesExtension;
import com.vladsch.flexmark.ext.attributes.AttributesNode;
import com.vladsch.flexmark.ext.attributes.internal.NodeAttributeRepository;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.NodeTracker;
import com.vladsch.flexmark.util.options.DataHolder;

public class AttributesNodePostProcessor
extends NodePostProcessor {
    private final NodeAttributeRepository nodeAttributeRepository;

    public AttributesNodePostProcessor(Document document) {
        this.nodeAttributeRepository = (NodeAttributeRepository)AttributesExtension.NODE_ATTRIBUTES.getFrom((DataHolder)document);
    }

    public void process(NodeTracker state, Node node) {
        if (node instanceof AttributesNode) {
            Node attributeOwner;
            AttributesNode attributesNode = (AttributesNode)node;
            Node sibling = attributesNode.getPrevious();
            if (sibling == null || sibling instanceof Text || sibling instanceof TextBase) {
                attributeOwner = attributesNode.getParent();
                if (attributeOwner instanceof Paragraph && sibling == null) {
                    sibling = attributeOwner.getPrevious();
                    attributeOwner = sibling == null ? attributeOwner.getParent() : sibling;
                }
            } else {
                attributeOwner = sibling;
            }
            this.nodeAttributeRepository.put(attributeOwner, attributesNode);
            if (attributeOwner instanceof AnchorRefTarget) {
                for (Node attributeNode : attributesNode.getChildren()) {
                    if (!(attributeNode instanceof AttributeNode) || !((AttributeNode)attributeNode).isId()) continue;
                    ((AnchorRefTarget)attributeOwner).setAnchorRefId(((AttributeNode)attributeNode).getValue().toString());
                }
            }
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Factory() {
            super(false);
            this.addNodes(new Class[]{AttributesNode.class});
        }

        public NodePostProcessor create(Document document) {
            return new AttributesNodePostProcessor(document);
        }
    }
}

