/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.attributes;

import com.vladsch.flexmark.ast.CustomNode;
import com.vladsch.flexmark.ast.DoNotDecorate;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class AttributeNode
extends CustomNode
implements DoNotDecorate {
    protected BasedSequence name = BasedSequence.NULL;
    protected BasedSequence attributeSeparator = BasedSequence.NULL;
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence value = BasedSequence.NULL;
    protected BasedSequence closingMarker = BasedSequence.NULL;

    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.name, this.attributeSeparator, this.openingMarker, this.value, this.closingMarker};
    }

    public void getAstExtra(StringBuilder out) {
        if (this.name.isNotNull()) {
            out.append(" name: ").append((CharSequence)this.name);
        }
        if (this.attributeSeparator.isNotNull()) {
            out.append((CharSequence)this.attributeSeparator);
        }
        AttributeNode.delimitedSegmentSpanChars((StringBuilder)out, (BasedSequence)this.openingMarker, (BasedSequence)this.value, (BasedSequence)this.closingMarker, (String)"value");
        if (this.isClass()) {
            out.append(" isClass");
        }
        if (this.isId()) {
            out.append(" isId");
        }
    }

    public AttributeNode() {
    }

    public AttributeNode(BasedSequence chars) {
        super(chars);
    }

    public AttributeNode(BasedSequence name, BasedSequence attributeSeparator, BasedSequence openingMarker, BasedSequence value, BasedSequence closingMarker) {
        super(AttributeNode.spanningChars((BasedSequence[])new BasedSequence[]{name, attributeSeparator, openingMarker, value, closingMarker}));
        this.name = name != null ? name : BasedSequence.NULL;
        this.attributeSeparator = attributeSeparator != null ? attributeSeparator : BasedSequence.NULL;
        this.openingMarker = openingMarker != null ? openingMarker : BasedSequence.NULL;
        this.value = value != null ? value : BasedSequence.NULL;
        this.closingMarker = closingMarker != null ? closingMarker : BasedSequence.NULL;
    }

    public static boolean isImplicitName(CharSequence name) {
        return name.length() > 0 && (name.charAt(0) == '.' || name.charAt(0) == '#');
    }

    public boolean isImplicitName() {
        return this.value.isNotNull() && this.name.isNull() && AttributeNode.isImplicitName((CharSequence)this.value);
    }

    public boolean isClass() {
        return this.value.isNotNull() && this.name.isNull() && this.value.startsWith((CharSequence)".") || this.name.equals("class");
    }

    public boolean isId() {
        return this.value.isNotNull() && this.name.isNull() && this.value.startsWith((CharSequence)"#") || this.name.equals("id");
    }

    public BasedSequence getImplicitNameValue() {
        return this.isImplicitName() ? this.value.subSequence(1) : this.value;
    }

    public BasedSequence getName() {
        return this.name;
    }

    public void setName(BasedSequence name) {
        this.name = name;
    }

    public BasedSequence getAttributeSeparator() {
        return this.attributeSeparator;
    }

    public void setAttributeSeparator(BasedSequence attributeSeparator) {
        this.attributeSeparator = attributeSeparator;
    }

    public BasedSequence getValue() {
        return this.value;
    }

    public void setValue(BasedSequence value) {
        this.value = value;
    }

    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker;
    }

    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }

    public void setClosingMarker(BasedSequence closingMarker) {
        this.closingMarker = closingMarker;
    }
}

