/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.keystorage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.virgilsecurity.sdk.crypto.KeyEntry;
import com.virgilsecurity.sdk.crypto.KeyStorage;
import com.virgilsecurity.sdk.crypto.exception.KeyEntryAlreadyExistsException;
import com.virgilsecurity.sdk.crypto.exception.KeyEntryNotFoundException;
import com.virgilsecurity.sdk.crypto.exception.KeyStorageException;
import com.virgilsecurity.sdk.keystorage.VirgilKeyEntry;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.charset.Charset;
import java.nio.file.InvalidPathException;

public class VirgilKeyStorage
implements KeyStorage {
    private String keysPath;

    public VirgilKeyStorage() {
        StringBuilder path = new StringBuilder(System.getProperty("user.home"));
        path.append(File.pathSeparator).append("VirgilSecurity");
        path.append(File.pathSeparator).append("Keys");
        this.keysPath = path.toString();
    }

    public VirgilKeyStorage(String keysPath) {
        this.keysPath = keysPath;
    }

    @Override
    public void store(KeyEntry keyEntry) {
        String name;
        File dir = new File(this.keysPath);
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new InvalidPathException(this.keysPath, "Is not a directory");
            }
        } else {
            dir.mkdirs();
        }
        if (this.exists(name = keyEntry.getName())) {
            throw new KeyEntryAlreadyExistsException();
        }
        String json = this.getGson().toJson((Object)keyEntry);
        File file = new File(dir, name.toLowerCase());
        try (FileOutputStream os = new FileOutputStream(file);){
            os.write(json.getBytes(Charset.forName("UTF-8")));
        }
        catch (Exception e) {
            throw new KeyStorageException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KeyEntry load(String keyName) {
        if (!this.exists(keyName)) {
            throw new KeyEntryNotFoundException();
        }
        File file = new File(this.keysPath, keyName.toLowerCase());
        try (FileInputStream is = new FileInputStream(file);){
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = is.read(buffer))) {
                os.write(buffer, 0, n);
            }
            byte[] bytes = os.toByteArray();
            VirgilKeyEntry entry = (VirgilKeyEntry)this.getGson().fromJson(new String(bytes, Charset.forName("UTF-8")), VirgilKeyEntry.class);
            entry.setName(keyName);
            VirgilKeyEntry virgilKeyEntry = entry;
            return virgilKeyEntry;
        }
        catch (Exception e) {
            throw new KeyStorageException(e);
        }
    }

    @Override
    public boolean exists(String keyName) {
        if (keyName == null) {
            return false;
        }
        File file = new File(this.keysPath, keyName);
        return file.exists();
    }

    @Override
    public void delete(String keyName) {
        if (!this.exists(keyName)) {
            throw new KeyEntryNotFoundException();
        }
        File file = new File(this.keysPath, keyName);
        file.delete();
    }

    private Gson getGson() {
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.create();
        return gson;
    }
}

