/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client;

import com.virgilsecurity.sdk.client.utils.StringUtils;
import java.net.URI;

public class VirgilClientContext {
    private String accessToken;
    private String cardsServiceAddress;
    private String readOnlyCardsServiceAddress;
    private String identityServiceAddress;

    public VirgilClientContext(String accessToken) {
        this.accessToken = accessToken;
        this.cardsServiceAddress = "https://cards.virgilsecurity.com";
        this.readOnlyCardsServiceAddress = "https://cards-ro.virgilsecurity.com";
        this.identityServiceAddress = "https://identity.virgilsecurity.com";
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getCardsServiceAddress() {
        return this.cardsServiceAddress;
    }

    public void setCardsServiceAddress(String address) {
        if (StringUtils.isBlank(address) && !VirgilClientContext.isValidURI(address)) {
            throw new IllegalArgumentException();
        }
        this.cardsServiceAddress = address;
    }

    public String getReadOnlyCardsServiceAddress() {
        return this.readOnlyCardsServiceAddress;
    }

    public void setReadOnlyCardsServiceAddress(String address) {
        if (StringUtils.isBlank(address) && !VirgilClientContext.isValidURI(address)) {
            throw new IllegalArgumentException();
        }
        this.readOnlyCardsServiceAddress = address;
    }

    public String getIdentityServiceAddress() {
        return this.identityServiceAddress;
    }

    public void setIdentityServiceAddress(String address) {
        if (StringUtils.isBlank(address) && !VirgilClientContext.isValidURI(address)) {
            throw new IllegalArgumentException();
        }
        this.identityServiceAddress = address;
    }

    public static boolean isValidURI(String uri) {
        if (StringUtils.isBlank(uri)) {
            return false;
        }
        try {
            URI theUri = URI.create(uri);
            return theUri.isAbsolute();
        }
        catch (Exception e) {
            return false;
        }
    }
}

