/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.crypto;

import com.virgilsecurity.crypto.virgil_crypto_javaJNI;

public class VirgilKeyPair
implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected VirgilKeyPair(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(VirgilKeyPair obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                virgil_crypto_javaJNI.delete_VirgilKeyPair(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public static VirgilKeyPair generate(Type type, byte[] pwd) {
        return new VirgilKeyPair(virgil_crypto_javaJNI.VirgilKeyPair_generate__SWIG_0(type.swigValue(), pwd), true);
    }

    public static VirgilKeyPair generate(Type type) {
        return new VirgilKeyPair(virgil_crypto_javaJNI.VirgilKeyPair_generate__SWIG_1(type.swigValue()), true);
    }

    public static VirgilKeyPair generateRecommended(byte[] pwd) {
        return new VirgilKeyPair(virgil_crypto_javaJNI.VirgilKeyPair_generateRecommended__SWIG_0(pwd), true);
    }

    public static VirgilKeyPair generateRecommended() {
        return new VirgilKeyPair(virgil_crypto_javaJNI.VirgilKeyPair_generateRecommended__SWIG_1(), true);
    }

    public static VirgilKeyPair generateFrom(VirgilKeyPair donorKeyPair, byte[] donorPrivateKeyPassword, byte[] newKeyPairPassword) {
        return new VirgilKeyPair(virgil_crypto_javaJNI.VirgilKeyPair_generateFrom__SWIG_0(VirgilKeyPair.getCPtr(donorKeyPair), donorKeyPair, donorPrivateKeyPassword, newKeyPairPassword), true);
    }

    public static VirgilKeyPair generateFrom(VirgilKeyPair donorKeyPair, byte[] donorPrivateKeyPassword) {
        return new VirgilKeyPair(virgil_crypto_javaJNI.VirgilKeyPair_generateFrom__SWIG_1(VirgilKeyPair.getCPtr(donorKeyPair), donorKeyPair, donorPrivateKeyPassword), true);
    }

    public static VirgilKeyPair generateFrom(VirgilKeyPair donorKeyPair) {
        return new VirgilKeyPair(virgil_crypto_javaJNI.VirgilKeyPair_generateFrom__SWIG_2(VirgilKeyPair.getCPtr(donorKeyPair), donorKeyPair), true);
    }

    public static boolean isKeyPairMatch(byte[] publicKey, byte[] privateKey, byte[] privateKeyPassword) {
        return virgil_crypto_javaJNI.VirgilKeyPair_isKeyPairMatch__SWIG_0(publicKey, privateKey, privateKeyPassword);
    }

    public static boolean isKeyPairMatch(byte[] publicKey, byte[] privateKey) {
        return virgil_crypto_javaJNI.VirgilKeyPair_isKeyPairMatch__SWIG_1(publicKey, privateKey);
    }

    public static boolean checkPrivateKeyPassword(byte[] key, byte[] pwd) {
        return virgil_crypto_javaJNI.VirgilKeyPair_checkPrivateKeyPassword(key, pwd);
    }

    public static boolean isPrivateKeyEncrypted(byte[] privateKey) {
        return virgil_crypto_javaJNI.VirgilKeyPair_isPrivateKeyEncrypted(privateKey);
    }

    public static byte[] resetPrivateKeyPassword(byte[] privateKey, byte[] oldPassword, byte[] newPassword) {
        return virgil_crypto_javaJNI.VirgilKeyPair_resetPrivateKeyPassword(privateKey, oldPassword, newPassword);
    }

    public static byte[] encryptPrivateKey(byte[] privateKey, byte[] privateKeyPassword) {
        return virgil_crypto_javaJNI.VirgilKeyPair_encryptPrivateKey(privateKey, privateKeyPassword);
    }

    public static byte[] decryptPrivateKey(byte[] privateKey, byte[] privateKeyPassword) {
        return virgil_crypto_javaJNI.VirgilKeyPair_decryptPrivateKey(privateKey, privateKeyPassword);
    }

    public static byte[] extractPublicKey(byte[] privateKey, byte[] privateKeyPassword) {
        return virgil_crypto_javaJNI.VirgilKeyPair_extractPublicKey(privateKey, privateKeyPassword);
    }

    public static byte[] publicKeyToPEM(byte[] publicKey) {
        return virgil_crypto_javaJNI.VirgilKeyPair_publicKeyToPEM(publicKey);
    }

    public static byte[] publicKeyToDER(byte[] publicKey) {
        return virgil_crypto_javaJNI.VirgilKeyPair_publicKeyToDER(publicKey);
    }

    public static byte[] privateKeyToPEM(byte[] privateKey, byte[] privateKeyPassword) {
        return virgil_crypto_javaJNI.VirgilKeyPair_privateKeyToPEM__SWIG_0(privateKey, privateKeyPassword);
    }

    public static byte[] privateKeyToPEM(byte[] privateKey) {
        return virgil_crypto_javaJNI.VirgilKeyPair_privateKeyToPEM__SWIG_1(privateKey);
    }

    public static byte[] privateKeyToDER(byte[] privateKey, byte[] privateKeyPassword) {
        return virgil_crypto_javaJNI.VirgilKeyPair_privateKeyToDER__SWIG_0(privateKey, privateKeyPassword);
    }

    public static byte[] privateKeyToDER(byte[] privateKey) {
        return virgil_crypto_javaJNI.VirgilKeyPair_privateKeyToDER__SWIG_1(privateKey);
    }

    public VirgilKeyPair(byte[] publicKey, byte[] privateKey) {
        this(virgil_crypto_javaJNI.new_VirgilKeyPair__SWIG_0(publicKey, privateKey), true);
    }

    public byte[] publicKey() {
        return virgil_crypto_javaJNI.VirgilKeyPair_publicKey(this.swigCPtr, this);
    }

    public byte[] privateKey() {
        return virgil_crypto_javaJNI.VirgilKeyPair_privateKey(this.swigCPtr, this);
    }

    public VirgilKeyPair(VirgilKeyPair other) {
        this(virgil_crypto_javaJNI.new_VirgilKeyPair__SWIG_1(VirgilKeyPair.getCPtr(other), other), true);
    }

    public static final class Type {
        public static final Type RSA_256 = new Type("RSA_256");
        public static final Type RSA_512 = new Type("RSA_512");
        public static final Type RSA_1024 = new Type("RSA_1024");
        public static final Type RSA_2048 = new Type("RSA_2048");
        public static final Type RSA_3072 = new Type("RSA_3072");
        public static final Type RSA_4096 = new Type("RSA_4096");
        public static final Type RSA_8192 = new Type("RSA_8192");
        public static final Type EC_SECP192R1 = new Type("EC_SECP192R1");
        public static final Type EC_SECP224R1 = new Type("EC_SECP224R1");
        public static final Type EC_SECP256R1 = new Type("EC_SECP256R1");
        public static final Type EC_SECP384R1 = new Type("EC_SECP384R1");
        public static final Type EC_SECP521R1 = new Type("EC_SECP521R1");
        public static final Type EC_BP256R1 = new Type("EC_BP256R1");
        public static final Type EC_BP384R1 = new Type("EC_BP384R1");
        public static final Type EC_BP512R1 = new Type("EC_BP512R1");
        public static final Type EC_SECP192K1 = new Type("EC_SECP192K1");
        public static final Type EC_SECP224K1 = new Type("EC_SECP224K1");
        public static final Type EC_SECP256K1 = new Type("EC_SECP256K1");
        public static final Type EC_CURVE25519 = new Type("EC_CURVE25519");
        public static final Type FAST_EC_X25519 = new Type("FAST_EC_X25519");
        public static final Type FAST_EC_ED25519 = new Type("FAST_EC_ED25519");
        private static Type[] swigValues = new Type[]{RSA_256, RSA_512, RSA_1024, RSA_2048, RSA_3072, RSA_4096, RSA_8192, EC_SECP192R1, EC_SECP224R1, EC_SECP256R1, EC_SECP384R1, EC_SECP521R1, EC_BP256R1, EC_BP384R1, EC_BP512R1, EC_SECP192K1, EC_SECP224K1, EC_SECP256K1, EC_CURVE25519, FAST_EC_X25519, FAST_EC_ED25519};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static Type swigToEnum(int swigValue) {
            if (swigValue < swigValues.length && swigValue >= 0 && Type.swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (Type.swigValues[i].swigValue != swigValue) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + Type.class + " with value " + swigValue);
        }

        private Type(String swigName) {
            this.swigName = swigName;
            this.swigValue = swigNext++;
        }

        private Type(String swigName, int swigValue) {
            this.swigName = swigName;
            this.swigValue = swigValue;
            swigNext = swigValue + 1;
        }

        private Type(String swigName, Type swigEnum) {
            this.swigName = swigName;
            this.swigValue = swigEnum.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

