/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.crypto.utils;

import com.virgilsecurity.crypto.VirgilPBKDF;
import com.virgilsecurity.sdk.crypto.Base64;

public class Obfuscator {
    public static String obfuscate(String value, String salt) {
        return Obfuscator.obfuscate(value, salt, VirgilPBKDF.Hash.SHA384, 2048);
    }

    public static String obfuscate(String value, String salt, VirgilPBKDF.Hash algorithm, int iterations) {
        byte[] saltData = salt.getBytes();
        try (VirgilPBKDF pbkdf = new VirgilPBKDF(saltData, iterations);){
            pbkdf.setHash(algorithm);
            byte[] valueData = value.getBytes();
            byte[] hash = pbkdf.derive(valueData);
            String string = Base64.encode(hash);
            return string;
        }
    }
}

