/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client.model.publickey;

import com.google.gson.annotations.SerializedName;
import com.virgilsecurity.sdk.client.model.Identity;
import com.virgilsecurity.sdk.client.utils.StringUtils;
import com.virgilsecurity.sdk.crypto.PublicKey;
import java.util.HashMap;
import java.util.Map;

public class VirgilCardTemplate {
    @SerializedName(value="public_key_id")
    private String publicKeyId;
    @SerializedName(value="public_key")
    private String publicKey;
    @SerializedName(value="identity")
    private Identity identity;
    @SerializedName(value="data")
    private Map<String, String> data;

    public String getPublicKeyId() {
        return this.publicKeyId;
    }

    public void setPublicKeyId(String publicKeyId) {
        this.publicKeyId = publicKeyId;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public void setIdentity(Identity identity) {
        this.identity = identity;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    public static class Builder {
        private String publicKeyId;
        private String publicKey;
        private Identity identity;
        private Map<String, String> data;

        public Builder setPublicKeyId(String publicKeyId) {
            if (this.publicKey != null) {
                throw new IllegalArgumentException("Public Key is already set");
            }
            if (StringUtils.isBlank(publicKeyId)) {
                throw new IllegalArgumentException("Public Key ID can't be blank");
            }
            this.publicKeyId = publicKeyId;
            return this;
        }

        public Builder setPublicKey(PublicKey publicKey) {
            this.publicKey = publicKey.getAsBase64String();
            return this;
        }

        public Builder setPublicKey(String publicKey) {
            if (this.publicKeyId != null) {
                throw new IllegalArgumentException("Public Key ID is already set");
            }
            if (StringUtils.isBlank(publicKey)) {
                throw new IllegalArgumentException("Public Key can't be blank");
            }
            this.publicKey = publicKey;
            return this;
        }

        public Builder setIdentity(Identity identity) {
            this.identity = identity;
            return this;
        }

        public Builder addData(String key, String value) {
            if (this.data == null) {
                this.data = new HashMap<String, String>();
            }
            this.data.put(key, value);
            return this;
        }

        public VirgilCardTemplate build() {
            VirgilCardTemplate request = new VirgilCardTemplate();
            request.setPublicKeyId(this.publicKeyId);
            request.setPublicKey(this.publicKey);
            request.setIdentity(this.identity);
            request.setData(this.data);
            return request;
        }
    }
}

