/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client;

import com.virgilsecurity.sdk.client.AbstractClient;
import com.virgilsecurity.sdk.client.exceptions.ServiceException;
import com.virgilsecurity.sdk.client.http.ResponseCallback;
import com.virgilsecurity.sdk.client.http.VoidResponseCallback;
import com.virgilsecurity.sdk.client.http.interceptors.RequestSignInterceptor;
import com.virgilsecurity.sdk.client.http.interceptors.TokenInterceptor;
import com.virgilsecurity.sdk.client.model.identity.ValidatedIdentity;
import com.virgilsecurity.sdk.client.model.publickey.DeleteRequest;
import com.virgilsecurity.sdk.client.model.publickey.Identities;
import com.virgilsecurity.sdk.client.model.publickey.PublicKeyInfo;
import com.virgilsecurity.sdk.client.model.publickey.SearchCriteria;
import com.virgilsecurity.sdk.client.model.publickey.VirgilCard;
import com.virgilsecurity.sdk.client.model.publickey.VirgilCardTemplate;
import com.virgilsecurity.sdk.client.service.PublicKeyService;
import com.virgilsecurity.sdk.crypto.Password;
import com.virgilsecurity.sdk.crypto.PrivateKey;
import java.io.IOException;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;

public class PublicKeyClient
extends AbstractClient {
    public static final String PUBLIC_KEY_BASE_URL = "https://keys.virgilsecurity.com";

    public PublicKeyClient(String accessToken) {
        this(PUBLIC_KEY_BASE_URL, accessToken);
    }

    public PublicKeyClient(String baseUrl, String accessToken) {
        super(baseUrl, accessToken);
    }

    @Override
    public <S> S createService(Class<S> serviceClass) {
        return this.createService(serviceClass, null, null);
    }

    public <S> S createService(Class<S> serviceClass, PrivateKey privateKey) {
        return this.createService(serviceClass, privateKey, null);
    }

    public <S> S createService(Class<S> serviceClass, PrivateKey privateKey, Password password) {
        OkHttpClient.Builder buider = new OkHttpClient.Builder();
        if (this.accessToken != null) {
            buider.addInterceptor((Interceptor)new TokenInterceptor(this.accessToken));
        }
        if (privateKey != null) {
            buider.addInterceptor((Interceptor)new RequestSignInterceptor(privateKey, password));
        }
        Retrofit retrofit = this.builder.client(buider.build()).build();
        return (S)retrofit.create(serviceClass);
    }

    public void createCard(VirgilCardTemplate template, PrivateKey privateKey, ResponseCallback<VirgilCard> callback) {
        this.createService(PublicKeyService.class, privateKey).createCard(template).enqueue(callback);
    }

    public void createCard(VirgilCardTemplate template, PrivateKey privateKey, Password password, ResponseCallback<VirgilCard> callback) {
        this.createService(PublicKeyService.class, privateKey, password).createCard(template).enqueue(callback);
    }

    public VirgilCard createCard(VirgilCardTemplate template, PrivateKey privateKey) {
        return this.createCard(template, privateKey, (Password)null);
    }

    public VirgilCard createCard(VirgilCardTemplate template, PrivateKey privateKey, Password password) {
        try {
            Response response = this.createService(PublicKeyService.class, privateKey, password).createCard(template).execute();
            return (VirgilCard)this.handleResponse(response);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    public void deleteKey(String publicKeyId, List<ValidatedIdentity> identities, VoidResponseCallback callback) throws IOException {
        Identities ids = new Identities();
        ids.setIdentities(identities);
        this.createService(PublicKeyService.class, null).deleteKey(publicKeyId, ids).enqueue((Callback)callback);
    }

    public VirgilCard getCard(String cardId) {
        try {
            Response response = this.createService(PublicKeyService.class).getCard(cardId).execute();
            return (VirgilCard)this.handleResponse(response);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    public void getCard(String cardId, ResponseCallback<VirgilCard> callback) {
        this.createService(PublicKeyService.class, null).getCard(cardId).enqueue(callback);
    }

    public PublicKeyInfo getKey(String publicKeyId) {
        try {
            Response response = this.createService(PublicKeyService.class).getKey(publicKeyId).execute();
            return (PublicKeyInfo)this.handleResponse(response);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    public void getKey(String publicKeyId, ResponseCallback<PublicKeyInfo> callback) {
        this.createService(PublicKeyService.class).getKey(publicKeyId).enqueue(callback);
    }

    public List<VirgilCard> search(SearchCriteria searchCriteria) {
        try {
            Call<List<VirgilCard>> call = null;
            PublicKeyService service = this.createService(PublicKeyService.class);
            call = "email".equals(searchCriteria.getType()) ? service.searchEmail(searchCriteria) : ("application".equals(searchCriteria.getType()) ? service.searchApp(searchCriteria) : service.search(searchCriteria));
            Response response = call.execute();
            return (List)this.handleResponse(response);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    public void search(SearchCriteria searchCriteria, ResponseCallback<List<VirgilCard>> callback) {
        Call<List<VirgilCard>> call = null;
        PublicKeyService service = this.createService(PublicKeyService.class);
        call = "email".equals(searchCriteria.getType()) ? service.searchEmail(searchCriteria) : ("application".equals(searchCriteria.getType()) ? service.searchApp(searchCriteria) : service.search(searchCriteria));
        call.enqueue(callback);
    }

    public void deleteCard(ValidatedIdentity identity, String signerCardId, PrivateKey privateKey) {
        this.deleteCard(identity, signerCardId, privateKey, (Password)null);
    }

    public void deleteCard(ValidatedIdentity identity, String cardId, PrivateKey privateKey, Password password) {
        try {
            DeleteRequest request = new DeleteRequest();
            request.setIdentity(identity);
            Response response = this.createService(PublicKeyService.class, privateKey, password).delete(cardId, cardId, request).execute();
            this.handleResponse(response);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public void deleteCard(ValidatedIdentity identity, String cardId, PrivateKey privateKey, VoidResponseCallback callback) {
        this.deleteCard(identity, cardId, privateKey, null, callback);
    }

    public void deleteCard(ValidatedIdentity identity, String cardId, PrivateKey privateKey, Password password, VoidResponseCallback callback) {
        DeleteRequest request = new DeleteRequest();
        request.setIdentity(identity);
        this.createService(PublicKeyService.class, privateKey, password).delete(cardId, cardId, request).enqueue((Callback)callback);
    }
}

