/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.crypto;

import com.virgilsecurity.crypto.VirgilCustomParams;
import com.virgilsecurity.crypto.virgil_crypto_javaJNI;

public class VirgilCipherBase
implements AutoCloseable {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected VirgilCipherBase(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(VirgilCipherBase obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                virgil_crypto_javaJNI.delete_VirgilCipherBase(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public VirgilCipherBase() {
        this(virgil_crypto_javaJNI.new_VirgilCipherBase(), true);
    }

    public void addKeyRecipient(byte[] recipientId, byte[] publicKey) {
        virgil_crypto_javaJNI.VirgilCipherBase_addKeyRecipient(this.swigCPtr, this, recipientId, publicKey);
    }

    public void removeKeyRecipient(byte[] recipientId) {
        virgil_crypto_javaJNI.VirgilCipherBase_removeKeyRecipient(this.swigCPtr, this, recipientId);
    }

    public boolean keyRecipientExists(byte[] recipientId) {
        return virgil_crypto_javaJNI.VirgilCipherBase_keyRecipientExists(this.swigCPtr, this, recipientId);
    }

    public void addPasswordRecipient(byte[] pwd) {
        virgil_crypto_javaJNI.VirgilCipherBase_addPasswordRecipient(this.swigCPtr, this, pwd);
    }

    public void removePasswordRecipient(byte[] pwd) {
        virgil_crypto_javaJNI.VirgilCipherBase_removePasswordRecipient(this.swigCPtr, this, pwd);
    }

    public void removeAllRecipients() {
        virgil_crypto_javaJNI.VirgilCipherBase_removeAllRecipients(this.swigCPtr, this);
    }

    public byte[] getContentInfo() {
        return virgil_crypto_javaJNI.VirgilCipherBase_getContentInfo(this.swigCPtr, this);
    }

    public void setContentInfo(byte[] contentInfo) {
        virgil_crypto_javaJNI.VirgilCipherBase_setContentInfo(this.swigCPtr, this, contentInfo);
    }

    public static long defineContentInfoSize(byte[] data) {
        return virgil_crypto_javaJNI.VirgilCipherBase_defineContentInfoSize(data);
    }

    public VirgilCustomParams customParams() {
        return new VirgilCustomParams(virgil_crypto_javaJNI.VirgilCipherBase_customParams__SWIG_0(this.swigCPtr, this), false);
    }

    public static byte[] computeShared(byte[] publicKey, byte[] privateKey, byte[] privateKeyPassword) {
        return virgil_crypto_javaJNI.VirgilCipherBase_computeShared__SWIG_0(publicKey, privateKey, privateKeyPassword);
    }

    public static byte[] computeShared(byte[] publicKey, byte[] privateKey) {
        return virgil_crypto_javaJNI.VirgilCipherBase_computeShared__SWIG_1(publicKey, privateKey);
    }
}

