/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.virgilsecurity.sdk.client.exceptions.ServiceException;
import com.virgilsecurity.sdk.client.model.APIError;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.GsonConverterFactory;
import retrofit2.Response;
import retrofit2.Retrofit;

public abstract class AbstractClient {
    protected OkHttpClient.Builder httpClient;
    protected Retrofit.Builder builder;
    protected String accessToken;

    public AbstractClient(String baseUrl, String accessToken) {
        this.accessToken = accessToken;
        this.httpClient = new OkHttpClient.Builder();
        this.httpClient.readTimeout(60L, TimeUnit.SECONDS);
        this.httpClient.connectTimeout(60L, TimeUnit.SECONDS);
        Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();
        this.builder = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson));
    }

    public <S> S createService(Class<S> serviceClass) {
        Retrofit retrofit = this.builder.client(this.httpClient.build()).build();
        return (S)retrofit.create(serviceClass);
    }

    public Object handleResponse(Response<?> response) throws IOException {
        if (response.isSuccess()) {
            return response.body();
        }
        APIError error = new APIError(response.code(), response.errorBody().string());
        throw new ServiceException(error);
    }
}

