/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client.http;

import com.virgilsecurity.sdk.client.model.APIError;
import java.io.IOException;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class VoidResponseCallback
implements Callback<Void> {
    public void onResponse(Call<Void> call, Response<Void> response) {
        if (response.code() < 400) {
            this.onSuccess(true);
        } else if (response.code() == 400) {
            this.onSuccess(false);
        } else {
            String body = "";
            try {
                body = response.errorBody().string();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.onFailure(new APIError(response.code(), body));
        }
    }

    public void onFailure(Call<Void> call, Throwable t) {
        this.onFailure(new APIError(t));
    }

    public abstract void onSuccess(boolean var1);

    public abstract void onFailure(APIError var1);
}

