/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client;

import com.virgilsecurity.sdk.client.IdentityClient;
import com.virgilsecurity.sdk.client.PrivateKeyClient;
import com.virgilsecurity.sdk.client.PublicKeyClient;
import com.virgilsecurity.sdk.client.model.publickey.VirgilCard;

public class ClientFactory {
    private String accessToken;
    private String identityBaseUrl;
    private String publicKeyBaseUrl;
    private String privateKeyBaseUrl;
    private IdentityClient identityClient;
    private PublicKeyClient publicKeyClient;
    private PrivateKeyClient privateKeyClient;

    public ClientFactory() {
    }

    public ClientFactory(String accessToken) {
        this.accessToken = accessToken;
    }

    public IdentityClient getIdentityClient() {
        if (this.identityClient == null) {
            this.identityClient = this.identityBaseUrl == null ? new IdentityClient() : new IdentityClient(this.identityBaseUrl);
        }
        return this.identityClient;
    }

    public PublicKeyClient getPublicKeyClient() {
        if (this.publicKeyClient == null) {
            this.publicKeyClient = this.publicKeyBaseUrl == null ? new PublicKeyClient(this.accessToken) : new PublicKeyClient(this.publicKeyBaseUrl, this.accessToken);
        }
        return this.publicKeyClient;
    }

    public PrivateKeyClient getPrivateKeyClient(VirgilCard serviceCard) {
        if (this.privateKeyClient == null) {
            this.privateKeyClient = this.privateKeyBaseUrl == null ? new PrivateKeyClient(this.accessToken, serviceCard) : new PrivateKeyClient(this.privateKeyBaseUrl, this.accessToken, serviceCard);
        }
        return this.privateKeyClient;
    }

    public void setIdentityBaseUrl(String identityBaseUrl) {
        this.identityBaseUrl = identityBaseUrl;
    }

    public void setPublicKeyBaseUrl(String publicKeyBaseUrl) {
        this.publicKeyBaseUrl = publicKeyBaseUrl;
    }

    public void setPrivateKeyBaseUrl(String privateKeyBaseUrl) {
        this.privateKeyBaseUrl = privateKeyBaseUrl;
    }
}

