/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.scan;

import com.vesoft.nebula.driver.graph.data.Edge;
import com.vesoft.nebula.driver.graph.data.Node;
import com.vesoft.nebula.driver.graph.data.ResultSet;
import com.vesoft.nebula.driver.graph.data.ValueWrapper;
import com.vesoft.nebula.driver.graph.scan.ScanResult;
import com.vesoft.nebula.driver.graph.scan.TableRow;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ScanEdgeResult
extends ScanResult {
    private List<String> propNames = new ArrayList<String>();
    private List<String> returnColumns = new ArrayList<String>();

    public ScanEdgeResult(List<ResultSet> results, List<String> propNames) {
        super(results);
        this.propNames = propNames;
        this.returnColumns.add("src");
        this.returnColumns.add("dst");
        this.returnColumns.addAll(propNames);
    }

    public List<String> getPropNames() {
        return this.returnColumns;
    }

    @Override
    protected void convertResultToRow() {
        if (this.isEmpty) {
            return;
        }
        if (this.tableRows.isEmpty()) {
            for (ResultSet resultSet : this.results) {
                while (resultSet.hasNext()) {
                    ResultSet.Record record = resultSet.next();
                    ArrayList<ValueWrapper> rowValues = new ArrayList<ValueWrapper>();
                    Node srcNode = record.get("src").asNode();
                    Node dstNode = record.get("dst").asNode();
                    Edge edge = record.get("edge").asEdge();
                    for (String key : srcNode.getProperties().keySet()) {
                        rowValues.add(srcNode.getProperties().get(key));
                    }
                    for (String key : dstNode.getProperties().keySet()) {
                        rowValues.add(dstNode.getProperties().get(key));
                    }
                    Map<String, ValueWrapper> properties = edge.getProperties();
                    for (String propName : this.propNames) {
                        rowValues.add(properties.get(propName));
                    }
                    this.tableRows.add(new TableRow(rowValues));
                }
            }
        }
    }
}

