/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.net;

import com.vesoft.nebula.driver.graph.data.HostAddress;
import com.vesoft.nebula.driver.graph.data.ResultSet;
import com.vesoft.nebula.driver.graph.data.ValueWrapper;
import com.vesoft.nebula.driver.graph.exception.AuthFailedException;
import com.vesoft.nebula.driver.graph.exception.IOErrorException;
import com.vesoft.nebula.driver.graph.net.AuthResult;
import com.vesoft.nebula.driver.graph.net.GrpcConnection;
import com.vesoft.nebula.driver.graph.scan.ScanEdgeResultIterator;
import com.vesoft.nebula.driver.graph.scan.ScanNodeResultIterator;
import com.vesoft.nebula.driver.graph.utils.AddressUtil;
import com.vesoft.nebula.driver.graph.utils.GqlUtil;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NebulaClient
implements Serializable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final long closeTimeout = 1000L;
    private List<HostAddress> servers;
    private Builder builder;
    private GrpcConnection connection;
    private long sessionId;
    private String version;
    private long createTime;
    private boolean isClosed = false;

    public static Builder builder(String addresses, String userName, String password) {
        return new Builder(addresses, userName, password);
    }

    public static Builder builder(String addresses, String userName) {
        return new Builder(addresses, userName, null);
    }

    public static Builder builder(Builder builder) {
        return builder;
    }

    private NebulaClient(Builder builder) throws AuthFailedException, IOErrorException {
        this.servers = builder.address;
        this.builder = builder;
        this.initClient();
    }

    public ResultSet execute(String gql) throws IOErrorException {
        return this.execute(gql, this.builder.requestTimeoutMills);
    }

    public synchronized ResultSet execute(String gql, long requestTimeout) throws IOErrorException {
        this.checkClosed();
        return new ResultSet(this.connection.execute(this.sessionId, gql, requestTimeout));
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public String getVersion() {
        return this.version;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public String getHost() {
        return this.connection.getServerAddress().toString();
    }

    public long getConnectTimeoutMills() {
        return this.builder.connectTimeoutMills;
    }

    public long getRequestTimeoutMills() {
        return this.builder.requestTimeoutMills;
    }

    public long getScanParallel() {
        return this.builder.scanParallel;
    }

    public synchronized boolean ping(long timeoutMs) {
        this.checkClosed();
        try {
            return this.connection.ping(this.sessionId, timeoutMs);
        }
        catch (IOErrorException e) {
            this.logger.error("ping error for host {}", (Object)this.getHost(), (Object)e);
            return false;
        }
    }

    public boolean ping() {
        return this.ping(1000L);
    }

    public synchronized void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            if (this.connection != null) {
                try {
                    this.connection.execute(this.sessionId, "SESSION CLOSE", 1000L);
                    this.connection.close();
                }
                catch (Exception e) {
                    this.logger.warn("signout failed,", (Throwable)e);
                }
            }
            this.connection = null;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    private void checkClosed() {
        if (this.isClosed) {
            throw new RuntimeException("The NebulaClient already closed.");
        }
    }

    private void initClient() throws AuthFailedException, IOErrorException {
        AuthResult authResult = null;
        this.connection = new GrpcConnection();
        int tryConnectTimes = this.servers.size();
        Collections.shuffle(this.servers);
        while (tryConnectTimes-- > 0) {
            try {
                this.connection.open(this.servers.get(tryConnectTimes), this.builder);
                authResult = this.connection.authenticate(this.builder.userName, this.builder.authOptions);
                this.sessionId = authResult.getSessionId();
                this.version = authResult.getVersion();
                this.createTime = System.currentTimeMillis();
                break;
            }
            catch (AuthFailedException e) {
                this.logger.error("create NebulaClient failed.", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                if (tryConnectTimes != 0) continue;
                this.logger.error("create NebulaClient failed.", (Throwable)e);
                throw e;
            }
        }
    }

    public ScanNodeResultIterator scanNode(String graphName, String nodeType) {
        List<Integer> parts = this.getAllParts();
        return this.scanNode(null, graphName, nodeType, new ArrayList<String>(), true, parts, 1000);
    }

    public ScanNodeResultIterator scanNode(String schema, String graphName, String nodeType) {
        List<Integer> parts = this.getAllParts();
        return this.scanNode(schema, graphName, nodeType, new ArrayList<String>(), true, parts, 1000);
    }

    public ScanNodeResultIterator scanNode(String graphName, String nodeType, List<String> returnProperties) {
        List<Integer> parts = this.getAllParts();
        boolean allProperties = false;
        if (returnProperties == null) {
            allProperties = true;
        }
        return this.scanNode(null, graphName, nodeType, returnProperties, allProperties, parts, 1000);
    }

    public ScanNodeResultIterator scanNode(String graphName, String nodeType, List<String> returnProperties, int batchSize) {
        List<Integer> parts = this.getAllParts();
        boolean allProperties = false;
        if (returnProperties == null) {
            allProperties = true;
        }
        return this.scanNode(null, graphName, nodeType, returnProperties, allProperties, parts, batchSize);
    }

    public ScanNodeResultIterator scanNode(String schema, String graphName, String nodeType, List<String> returnProperties, int batchSize) {
        List<Integer> parts = this.getAllParts();
        boolean allProperties = false;
        if (returnProperties == null) {
            allProperties = true;
        }
        return this.scanNode(schema, graphName, nodeType, returnProperties, allProperties, parts, batchSize);
    }

    public ScanNodeResultIterator scanNode(String graphName, String nodeType, List<String> returnProperties, int part, int batchSize) {
        return this.scanNode(graphName, nodeType, returnProperties, Collections.singletonList(part), batchSize);
    }

    public ScanNodeResultIterator scanNode(String schema, String graphName, String nodeType, List<String> returnProperties, int part, int batchSize) {
        return this.scanNode(schema, graphName, nodeType, returnProperties, Collections.singletonList(part), batchSize);
    }

    public ScanNodeResultIterator scanNode(String graphName, String nodeType, List<String> returnProperties, List<Integer> parts, int batchSize) {
        boolean allProperties = false;
        if (returnProperties == null) {
            allProperties = true;
        }
        return this.scanNode(null, graphName, nodeType, returnProperties, allProperties, parts, batchSize);
    }

    public ScanNodeResultIterator scanNode(String schema, String graphName, String nodeType, List<String> returnProperties, List<Integer> parts, int batchSize) {
        boolean allProperties = false;
        if (returnProperties == null) {
            allProperties = true;
        }
        return this.scanNode(schema, graphName, nodeType, returnProperties, allProperties, parts, batchSize);
    }

    private ScanNodeResultIterator scanNode(String schema, String graphName, String nodeType, List<String> returnProperties, boolean allProperties, List<Integer> parts, int batchSize) {
        List<String> nodeProperties = null;
        try {
            nodeProperties = this.getNodeProperties(graphName, nodeType);
        }
        catch (IOErrorException e) {
            this.logger.error("get node schema failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
        ArrayList<String> propertyList = new ArrayList<String>();
        if (allProperties) {
            propertyList.addAll(nodeProperties);
        } else {
            String primaryKey = nodeProperties.get(0);
            propertyList.add(primaryKey);
            for (String propName : returnProperties) {
                if (propName.trim().equals(primaryKey)) continue;
                propertyList.add(propName);
            }
        }
        return new ScanNodeResultIterator(schema, graphName, nodeType, propertyList, parts, batchSize, this.builder.scanParallel, this.servers, this.builder);
    }

    public ScanEdgeResultIterator scanEdge(String graphName, String edgeType) {
        List<Integer> parts = this.getAllParts();
        return this.scanEdge(null, graphName, edgeType, new ArrayList<String>(), true, parts, 1000);
    }

    public ScanEdgeResultIterator scanEdge(String schema, String graphName, String edgeType) {
        List<Integer> parts = this.getAllParts();
        return this.scanEdge(schema, graphName, edgeType, new ArrayList<String>(), true, parts, 1000);
    }

    public ScanEdgeResultIterator scanEdge(String graphName, String edgeType, List<String> returnProperties) {
        List<Integer> parts = this.getAllParts();
        boolean allProperties = false;
        if (returnProperties == null) {
            allProperties = true;
        }
        return this.scanEdge(null, graphName, edgeType, returnProperties, allProperties, parts, 1000);
    }

    public ScanEdgeResultIterator scanEdge(String graphName, String edgeType, List<String> returnProperties, int batchSize) {
        boolean allProperties = false;
        if (returnProperties == null) {
            allProperties = true;
        }
        List<Integer> parts = this.getAllParts();
        return this.scanEdge(null, graphName, edgeType, returnProperties, allProperties, parts, batchSize);
    }

    public ScanEdgeResultIterator scanEdge(String schema, String graphName, String edgeType, List<String> returnProperties, int batchSize) {
        boolean allProperties = false;
        if (returnProperties == null) {
            allProperties = true;
        }
        List<Integer> parts = this.getAllParts();
        return this.scanEdge(schema, graphName, edgeType, returnProperties, allProperties, parts, batchSize);
    }

    public ScanEdgeResultIterator scanEdge(String graphName, String edgeType, List<String> returnProperties, int part, int batchSize) {
        boolean allProperties = false;
        if (returnProperties == null) {
            allProperties = true;
        }
        return this.scanEdge(null, graphName, edgeType, returnProperties, allProperties, Collections.singletonList(part), batchSize);
    }

    public ScanEdgeResultIterator scanEdge(String schema, String graphName, String edgeType, List<String> returnProperties, int part, int batchSize) {
        boolean allProperties = false;
        if (returnProperties == null) {
            allProperties = true;
        }
        return this.scanEdge(schema, graphName, edgeType, returnProperties, allProperties, Collections.singletonList(part), batchSize);
    }

    public ScanEdgeResultIterator scanEdge(String graphName, String edgeType, List<String> returnProperties, List<Integer> parts, int batchSize) {
        boolean allProperties = false;
        if (returnProperties == null) {
            allProperties = true;
        }
        return this.scanEdge(null, graphName, edgeType, returnProperties, allProperties, parts, batchSize);
    }

    public ScanEdgeResultIterator scanEdge(String schema, String graphName, String edgeType, List<String> returnProperties, List<Integer> parts, int batchSize) {
        boolean allProperties = false;
        if (returnProperties == null) {
            allProperties = true;
        }
        return this.scanEdge(schema, graphName, edgeType, returnProperties, allProperties, parts, batchSize);
    }

    private ScanEdgeResultIterator scanEdge(String schema, String graphName, String edgeType, List<String> returnProperties, boolean allProperties, List<Integer> parts, int batchSize) {
        List<String> edgeProperties = null;
        try {
            edgeProperties = this.getEdgeProperties(graphName, edgeType);
        }
        catch (IOErrorException e) {
            this.logger.error("get node schema failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
        ArrayList<String> propertyList = new ArrayList<String>();
        if (allProperties) {
            propertyList.addAll(edgeProperties);
        } else {
            propertyList.addAll(returnProperties);
        }
        return new ScanEdgeResultIterator(schema, graphName, edgeType, propertyList, parts, batchSize, this.builder.scanParallel, this.servers, this.builder);
    }

    private List<Integer> getAllParts() {
        ResultSet resultSet;
        String showPartitions = "CALL show_partitions() RETURN *";
        try {
            resultSet = this.execute(showPartitions);
        }
        catch (Exception e) {
            this.logger.error("get all partitions error", (Throwable)e);
            throw new RuntimeException("get all partitions error", e);
        }
        if (!resultSet.isSucceeded() || resultSet.isEmpty()) {
            this.logger.error("get all partitions failed for {}", (Object)resultSet.getErrorMessage());
            throw new RuntimeException("get all partitions failed for " + resultSet.getErrorMessage());
        }
        ArrayList<Integer> partitions = new ArrayList<Integer>();
        while (resultSet.hasNext()) {
            partitions.add(resultSet.next().get("partition_id").asInt());
        }
        if (partitions.contains(0)) {
            partitions.remove((Object)0);
        }
        return partitions;
    }

    private List<String> getNodeProperties(String graphName, String nodeType) throws IOErrorException {
        String graphType = this.getGraphType(graphName);
        String descNodeType = String.format("DESCRIBE NODE TYPE `%s` OF `%s`", GqlUtil.escape(nodeType), GqlUtil.escape(graphType));
        ResultSet resultSet = this.execute(descNodeType);
        if (!resultSet.isSucceeded() || resultSet.isEmpty()) {
            this.logger.error(String.format("get description of %s failed for %s", nodeType, resultSet.getErrorMessage()));
            throw new IllegalArgumentException(String.format("node type %s does not exist in %s", nodeType, graphName));
        }
        ArrayList<String> pks = new ArrayList<String>();
        ArrayList<String> propNames = new ArrayList<String>();
        while (resultSet.hasNext()) {
            ResultSet.Record record = resultSet.next();
            propNames.add(record.get("property_name").asString());
            if (!"Y".equals(record.get("primary_key").asString())) continue;
            pks.add(record.get("property_name").asString());
        }
        if (pks.isEmpty()) {
            this.logger.error("node type " + nodeType + " has no primary key.");
            throw new RuntimeException("node type " + nodeType + " has no primary key");
        }
        ArrayList<String> propertyNames = new ArrayList<String>(pks);
        for (String property : propNames) {
            if (pks.contains(property)) continue;
            propertyNames.add(property);
        }
        return propertyNames;
    }

    private List<String> getEdgeProperties(String graphName, String edgeType) throws IOErrorException {
        String graphType = this.getGraphType(graphName);
        String descEdgeType = String.format("CALL describe_graph_type(\"%s\") FILTER type_name=\"%s\" return properties", GqlUtil.escape(graphType), GqlUtil.escape(edgeType));
        ResultSet resultSet = this.execute(descEdgeType);
        if (!resultSet.isSucceeded() || resultSet.isEmpty()) {
            this.logger.error(String.format("get description of %s failed for %s", edgeType, resultSet.getErrorMessage()));
            throw new IllegalArgumentException(String.format("edge type %s does not exist in %s", edgeType, graphName));
        }
        List<ValueWrapper> properties = resultSet.next().get("properties").asList();
        return properties.stream().map(ValueWrapper::asString).collect(Collectors.toList());
    }

    private String getGraphType(String graphName) throws IOErrorException {
        ResultSet resultSet = this.execute(String.format("DESCRIBE GRAPH `%s`", GqlUtil.escape(graphName)));
        if (!resultSet.isSucceeded() || resultSet.isEmpty()) {
            throw new IllegalArgumentException("graphName " + graphName + " does not exist.");
        }
        String graphType = resultSet.next().values().get(1).asString();
        return graphType;
    }

    public static class Builder {
        protected final List<HostAddress> address;
        protected final String userName;
        protected final String password;
        protected Map<String, Object> authOptions = new HashMap<String, Object>();
        protected long connectTimeoutMills = 3000L;
        protected long requestTimeoutMills = 60000L;
        protected int scanParallel = 10;
        protected boolean enableTls = false;
        protected boolean disableVerifyServerCert = false;
        protected String tlsCa;
        protected String tlsCert;
        protected String tlsKey;

        public Builder(String addresses, String userName, String password) {
            try {
                this.address = AddressUtil.validateAddress(addresses);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            this.userName = userName;
            this.password = password;
        }

        public Builder withAuthOptions(Map<String, Object> authOptions) {
            if (authOptions != null) {
                this.authOptions.putAll(authOptions);
            }
            return this;
        }

        public Builder withConnectTimeoutMills(long connectTimeoutMills) {
            this.connectTimeoutMills = connectTimeoutMills <= 0L || connectTimeoutMills > Integer.MAX_VALUE ? Integer.MAX_VALUE : connectTimeoutMills;
            return this;
        }

        public Builder withRequestTimeoutMills(long requestTimeoutMills) {
            this.requestTimeoutMills = requestTimeoutMills < 0L || requestTimeoutMills > Integer.MAX_VALUE ? Integer.MAX_VALUE : requestTimeoutMills;
            return this;
        }

        public Builder withScanParallel(int scanParallel) {
            this.scanParallel = scanParallel;
            return this;
        }

        public Builder withEnableTls(boolean enableTls) {
            this.enableTls = enableTls;
            return this;
        }

        public Builder withDisableVerifyServerCert(boolean disableVerifyServerCert) {
            this.disableVerifyServerCert = disableVerifyServerCert;
            return this;
        }

        public Builder withTlsCa(String ca) {
            this.tlsCa = ca;
            return this;
        }

        public Builder withTlsCert(String cert, String key) {
            this.tlsCert = cert;
            this.tlsKey = key;
            return this;
        }

        public void check() {
            if (this.address == null) {
                throw new IllegalArgumentException("Graph addresses cannot be empty.");
            }
            if (this.enableTls && !this.disableVerifyServerCert && this.tlsCa == null) {
                throw new IllegalArgumentException("TLS is enable, tlsCa cannot be empty.");
            }
        }

        public NebulaClient build() throws AuthFailedException, IOErrorException {
            this.check();
            if (this.password != null) {
                this.authOptions.put("password", this.password);
            }
            return new NebulaClient(this);
        }

        public List<HostAddress> getAddress() {
            return this.address;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }

        public Map<String, Object> getAuthOptions() {
            return this.authOptions;
        }

        public long getConnectTimeoutMills() {
            return this.connectTimeoutMills;
        }

        public long getRequestTimeoutMills() {
            return this.requestTimeoutMills;
        }

        public int getScanParallel() {
            return this.scanParallel;
        }

        public boolean isEnableTls() {
            return this.enableTls;
        }

        public boolean isDisableVerifyServerCert() {
            return this.disableVerifyServerCert;
        }

        public String getTlsCa() {
            return this.tlsCa;
        }

        public String getTlsCert() {
            return this.tlsCert;
        }

        public String getTlsKey() {
            return this.tlsKey;
        }
    }
}

