/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.data;

import com.google.common.base.Charsets;
import com.vesoft.nebula.driver.graph.ErrorCode;
import com.vesoft.nebula.driver.graph.data.ExtraInfo;
import com.vesoft.nebula.driver.graph.data.PlanInfoNode;
import com.vesoft.nebula.driver.graph.data.ValueWrapper;
import com.vesoft.nebula.driver.graph.decode.ResultTable;
import com.vesoft.nebula.driver.graph.decode.Row;
import com.vesoft.nebula.proto.graph.ExecuteResponse;
import com.vesoft.nebula.proto.graph.QueryStats;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class ResultSet {
    private final ExecuteResponse response;
    private final ResultTable resultTable;
    private final List<String> columnNames = new ArrayList<String>();
    private final Charset charset = Charsets.UTF_8;
    private boolean isEmpty = false;
    private volatile AtomicInteger index = new AtomicInteger(0);
    private final long size;

    public ResultSet(ExecuteResponse resp) {
        if (resp == null) {
            throw new RuntimeException("got null object for server's response");
        }
        this.resultTable = new ResultTable(resp.getResult());
        this.response = resp;
        if (!resp.hasResult()) {
            this.size = 0L;
        } else {
            this.columnNames.addAll(this.resultTable.getColumnNames());
            this.size = this.resultTable.getTotalNumRecords();
        }
        this.isEmpty = this.size == 0L;
    }

    public boolean isSucceeded() {
        return ErrorCode.SUCCESSFUL_COMPLETION.code.equals(this.response.getStatus().getCode().toString(this.charset));
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public ErrorCode getErrorCode() {
        return ErrorCode.find(this.response.getStatus().getCode().toString(this.charset));
    }

    public String getErrorMessage() {
        return this.response.getStatus().getMessage().toString(this.charset);
    }

    public long getLatency() {
        return this.response.getSummary().getElapsedTime().getTotalServerTimeUs();
    }

    public PlanInfoNode getPlanDesc() {
        return new PlanInfoNode(this.response.getSummary().getPlanInfo());
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public long rowSize() {
        if (this.isEmpty) {
            return 0L;
        }
        return this.size;
    }

    public boolean hasNext() {
        if (this.isEmpty) {
            return false;
        }
        return (long)this.index.get() < this.size;
    }

    public Record next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("no more row record data");
        }
        Row row = this.resultTable.next();
        this.index.getAndIncrement();
        return new Record(this.columnNames, row);
    }

    public ExtraInfo getExtraInfo() {
        if (!this.response.hasSummary()) {
            return new ExtraInfo();
        }
        ExtraInfo extraInfo = new ExtraInfo();
        QueryStats queryStats = this.response.getSummary().getQueryStats();
        extraInfo.setAffectedNodes(queryStats.getNumAffectedNodes());
        extraInfo.setAffectedEdges(queryStats.getNumAffectedEdges());
        extraInfo.setCursor(this.response.getCursor().toString(this.charset));
        extraInfo.setParseTimeUs(this.response.getSummary().getElapsedTime().getParseTimeUs());
        extraInfo.setBuildTimeUs(this.response.getSummary().getElapsedTime().getBuildTimeUs());
        extraInfo.setOptimizeTimeUs(this.response.getSummary().getElapsedTime().getOptimizeTimeUs());
        extraInfo.setSerializeTimeUs(this.response.getSummary().getElapsedTime().getSerializeTimeUs());
        extraInfo.setTotalServerTimeUs(this.response.getSummary().getElapsedTime().getTotalServerTimeUs());
        extraInfo.setNumWarnings(this.response.getSummary().getNumWarnings());
        extraInfo.setNumExportedRecords(queryStats.getNumExportedRecords());
        extraInfo.setExportPaths(queryStats.getExportedPathsList());
        return extraInfo;
    }

    public String toString() {
        if (!this.isSucceeded()) {
            return this.response.getStatus().getMessage().toString(this.charset);
        }
        return String.format("ColumnName: %s, RowSize: %s, Latency: %d", this.columnNames, this.rowSize(), this.getLatency());
    }

    public static class Record
    implements Iterable<ValueWrapper> {
        private final List<ValueWrapper> colValues = new ArrayList<ValueWrapper>();
        private List<String> columnNames = new ArrayList<String>();

        public Record(List<String> columnNames, Row row) {
            if (columnNames == null) {
                return;
            }
            if (row == null || row.getValues().isEmpty()) {
                return;
            }
            for (ValueWrapper value : row.getValues()) {
                this.colValues.add(value);
            }
            this.columnNames = columnNames;
        }

        @Override
        public Iterator<ValueWrapper> iterator() {
            return this.colValues.iterator();
        }

        @Override
        public void forEach(Consumer<? super ValueWrapper> action) {
            this.colValues.forEach(action);
        }

        @Override
        public Spliterator<ValueWrapper> spliterator() {
            return this.colValues.spliterator();
        }

        public String toString() {
            ArrayList<String> valueStr = new ArrayList<String>();
            for (ValueWrapper v : this.colValues) {
                valueStr.add(v.toString());
            }
            return String.format("ColumnName: %s, Values: %s", this.columnNames.toString(), ((Object)valueStr).toString());
        }

        public ValueWrapper get(int index) {
            if (index >= this.columnNames.size()) {
                throw new IllegalArgumentException(String.format("Cannot get field because the key '%d' out of range", index));
            }
            return this.colValues.get(index);
        }

        public ValueWrapper get(String columnName) {
            int index = this.columnNames.indexOf(columnName);
            if (index == -1) {
                throw new IllegalArgumentException("Cannot get field because the columnName '" + columnName + "' is not exists");
            }
            return this.colValues.get(index);
        }

        public List<ValueWrapper> values() {
            return this.colValues;
        }

        public int size() {
            return this.columnNames.size();
        }

        public boolean contains(String columnName) {
            return this.columnNames.contains(columnName);
        }
    }
}

