/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.decode.struct;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class PathHeader {
    private long size;
    private int headNodeIndex;
    private int tailNodeIndex;
    private int headOffset;
    private int tailOffset;

    public PathHeader(ByteString byteString, ByteOrder order) {
        ByteBuffer buffer = ByteBuffer.wrap(byteString.toByteArray()).order(order);
        this.size = Integer.toUnsignedLong(buffer.getInt());
        this.headNodeIndex = buffer.getShort() & 0xFFFF;
        this.tailNodeIndex = buffer.getShort() & 0xFFFF;
        this.headOffset = buffer.getInt();
        this.tailOffset = buffer.getInt();
    }

    public int getHeadNodeIndex() {
        return this.headNodeIndex;
    }

    public int getTailNodeIndex() {
        return this.tailNodeIndex;
    }

    public long getSize() {
        return this.size;
    }

    public int getHeadOffset() {
        return this.headOffset;
    }

    public int getTailOffset() {
        return this.tailOffset;
    }
}

