/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class WKTFileReader {
    private File file = null;
    private Reader reader;
    private WKTReader wktReader;
    private int count = 0;
    private int limit = -1;
    private int offset = 0;
    private static final int MAX_LOOKAHEAD = 1000;

    public WKTFileReader(File file, WKTReader wktReader) {
        this.file = file;
        this.wktReader = wktReader;
    }

    public WKTFileReader(String filename, WKTReader wktReader) {
        this(new File(filename), wktReader);
    }

    public WKTFileReader(Reader reader, WKTReader wktReader) {
        this.reader = reader;
        this.wktReader = wktReader;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public List read() throws IOException, ParseException {
        if (this.file != null) {
            this.reader = new FileReader(this.file);
        }
        this.count = 0;
        try {
            List list;
            BufferedReader bufferedReader = new BufferedReader(this.reader);
            try {
                list = this.read(bufferedReader);
            }
            catch (Throwable throwable) {
                bufferedReader.close();
                throw throwable;
            }
            bufferedReader.close();
            return list;
        }
        finally {
            this.reader.close();
        }
    }

    private List read(BufferedReader bufferedReader) throws IOException, ParseException {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        while (!this.isAtEndOfFile(bufferedReader) && !this.isAtLimit(geoms)) {
            Geometry g2 = this.wktReader.read(bufferedReader);
            if (this.count >= this.offset) {
                geoms.add(g2);
            }
            ++this.count;
        }
        return geoms;
    }

    private boolean isAtLimit(List geoms) {
        if (this.limit < 0) {
            return false;
        }
        return geoms.size() >= this.limit;
    }

    private boolean isAtEndOfFile(BufferedReader bufferedReader) throws IOException {
        bufferedReader.mark(1000);
        StreamTokenizer tokenizer = new StreamTokenizer(bufferedReader);
        int type = tokenizer.nextToken();
        if (type == -1) {
            return true;
        }
        bufferedReader.reset();
        return false;
    }
}

