/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.data;

import com.vesoft.nebula.client.graph.data.BaseDataObject;
import com.vesoft.nebula.client.graph.data.ValueWrapper;
import com.vesoft.nebula.proto.common.Edge;
import com.vesoft.nebula.proto.common.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Relationship
extends BaseDataObject {
    private final Edge edge;

    public Relationship(Edge edge) {
        if (edge == null) {
            throw new RuntimeException("Input an null edge object");
        }
        this.edge = edge;
    }

    public String getGraph() {
        return this.edge.getGraph();
    }

    public String getType() {
        return this.edge.getType();
    }

    public boolean isDirected() {
        return this.edge.getDirection() == Edge.Direction.DIRECTED;
    }

    public List<String> getLabels() {
        return this.edge.getLabelsList();
    }

    public long getSrcId() {
        return this.edge.getSrcId();
    }

    public long getDstId() {
        return this.edge.getDstId();
    }

    public long getRank() {
        return this.edge.getRank();
    }

    public List<String> getColumnNames() {
        return new ArrayList<String>(this.edge.getPropertiesMap().keySet());
    }

    public List<ValueWrapper> getPropertyValues() {
        ArrayList<ValueWrapper> values = new ArrayList<ValueWrapper>();
        for (Map.Entry<String, Value> kv : this.edge.getPropertiesMap().entrySet()) {
            values.add(new ValueWrapper(kv.getValue()));
        }
        return values;
    }

    public HashMap<String, ValueWrapper> getProperties() {
        HashMap<String, ValueWrapper> properties = new HashMap<String, ValueWrapper>();
        for (String key : this.edge.getPropertiesMap().keySet()) {
            properties.put(key, new ValueWrapper(this.edge.getPropertiesMap().get(key)));
        }
        return properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Relationship that = (Relationship)o;
        if (this.edge.getDirection() == Edge.Direction.DIRECTED) {
            return this.getRank() == that.getRank() && this.getSrcId() == that.getSrcId() && this.getDstId() == that.getDstId() && Objects.equals(this.getType(), that.getType());
        }
        return this.getRank() == that.getRank() && (this.getSrcId() == that.getSrcId() && this.getDstId() == that.getDstId() || this.getSrcId() == that.getDstId() && this.getDstId() == that.getSrcId()) && Objects.equals(this.getType(), that.getType());
    }

    public int hashCode() {
        return Objects.hash(this.edge, this.getDecodeType());
    }

    public String toString() {
        ArrayList<String> propStrs = new ArrayList<String>();
        HashMap<String, ValueWrapper> props = this.getProperties();
        for (String key : props.keySet()) {
            propStrs.add(key + ":" + ((ValueWrapper)props.get(key)).toString());
        }
        if (this.edge.getDirection() == Edge.Direction.DIRECTED) {
            return String.format("(%d)-[%d@%s:%s{%s}]->(%d)", this.getSrcId(), this.getRank(), this.getType(), String.join((CharSequence)"&", this.getLabels()), String.join((CharSequence)",", propStrs), this.getDstId());
        }
        return String.format("(%d)~[%d@%s:%s{%s}]~(%d)", this.getSrcId(), this.getRank(), this.getType(), String.join((CharSequence)"&", this.getLabels()), String.join((CharSequence)", ", propStrs), this.getDstId());
    }
}

