/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.storage;

import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.graph.data.SSLParam;
import com.vesoft.nebula.client.meta.MetaManager;
import com.vesoft.nebula.client.storage.GraphStorageConnection;
import com.vesoft.nebula.client.storage.StorageConnPool;
import com.vesoft.nebula.client.storage.StoragePoolConfig;
import com.vesoft.nebula.client.storage.scan.PartScanInfo;
import com.vesoft.nebula.client.storage.scan.ScanEdgeResultIterator;
import com.vesoft.nebula.client.storage.scan.ScanVertexResultIterator;
import com.vesoft.nebula.meta.ColumnDef;
import com.vesoft.nebula.meta.Schema;
import com.vesoft.nebula.storage.EdgeProp;
import com.vesoft.nebula.storage.ScanEdgeRequest;
import com.vesoft.nebula.storage.ScanVertexRequest;
import com.vesoft.nebula.storage.VertexProp;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageClient
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageClient.class);
    private final GraphStorageConnection connection = new GraphStorageConnection();
    private StorageConnPool pool;
    private MetaManager metaManager;
    private final List<HostAddress> addresses;
    private int timeout = 10000;
    private int connectionRetry = 3;
    private int executionRetry = 1;
    private boolean enableSSL = false;
    private SSLParam sslParam = null;
    private String user = null;
    private String password = null;
    private Map<String, String> storageAddressMapping = null;
    private static final int DEFAULT_LIMIT = 1000;
    private static final long DEFAULT_START_TIME = 0L;
    private static final long DEFAULT_END_TIME = Long.MAX_VALUE;
    private static final boolean DEFAULT_ALLOW_PART_SUCCESS = false;
    private static final boolean DEFAULT_ALLOW_READ_FOLLOWER = false;

    public StorageClient(String ip, int port) {
        this(Arrays.asList(new HostAddress(ip, port)));
    }

    public StorageClient(List<HostAddress> addresses) {
        this.addresses = addresses;
    }

    public StorageClient(List<HostAddress> addresses, int timeout) {
        this.addresses = addresses;
        this.timeout = timeout;
    }

    public StorageClient(List<HostAddress> addresses, int timeout, int connectionRetry, int executionRetry, boolean enableSSL, SSLParam sslParam) {
        this(addresses, timeout);
        this.connectionRetry = connectionRetry;
        this.executionRetry = executionRetry;
        this.enableSSL = enableSSL;
        this.sslParam = sslParam;
        if (enableSSL && sslParam == null) {
            throw new IllegalArgumentException("SSL is enabled, but SSLParam is nul.");
        }
    }

    public boolean connect() throws Exception {
        this.connection.open(this.addresses.get(0), this.timeout, this.enableSSL, this.sslParam);
        StoragePoolConfig config = new StoragePoolConfig();
        config.setEnableSSL(this.enableSSL);
        config.setSslParam(this.sslParam);
        this.pool = new StorageConnPool(config);
        this.metaManager = new MetaManager(this.addresses, this.timeout, this.connectionRetry, this.executionRetry, this.enableSSL, this.sslParam);
        this.metaManager.addStorageAddrMapping(this.storageAddressMapping);
        return true;
    }

    public StorageClient setUser(String user) {
        this.user = user;
        return this;
    }

    public StorageClient setPassword(String password) {
        this.password = password;
        return this;
    }

    public void setStorageAddressMapping(Map<String, String> storageAddressMapping) {
        this.storageAddressMapping = storageAddressMapping;
        if (this.metaManager != null) {
            this.metaManager.addStorageAddrMapping(storageAddressMapping);
        }
    }

    public ScanVertexResultIterator scanVertex(String spaceName, String tagName, List<String> returnCols) {
        return this.scanVertex(spaceName, tagName, returnCols, 1000);
    }

    public ScanVertexResultIterator scanVertex(String spaceName, int part, String tagName, List<String> returnCols) {
        return this.scanVertex(spaceName, part, tagName, returnCols, 1000);
    }

    public ScanVertexResultIterator scanVertex(String spaceName, String tagName) {
        return this.scanVertex(spaceName, tagName, 1000);
    }

    public ScanVertexResultIterator scanVertex(String spaceName, int part, String tagName) {
        return this.scanVertex(spaceName, part, tagName, 1000);
    }

    public ScanVertexResultIterator scanVertex(String spaceName, String tagName, List<String> returnCols, int limit) {
        return this.scanVertex(spaceName, tagName, returnCols, limit, 0L, Long.MAX_VALUE);
    }

    public ScanVertexResultIterator scanVertex(String spaceName, int part, String tagName, List<String> returnCols, int limit) {
        return this.scanVertex(spaceName, part, tagName, returnCols, limit, 0L, Long.MAX_VALUE);
    }

    public ScanVertexResultIterator scanVertex(String spaceName, String tagName, int limit) {
        return this.scanVertex(spaceName, tagName, limit, 0L, Long.MAX_VALUE);
    }

    public ScanVertexResultIterator scanVertex(String spaceName, int part, String tagName, int limit) {
        return this.scanVertex(spaceName, part, tagName, limit, 0L, Long.MAX_VALUE);
    }

    public ScanVertexResultIterator scanVertex(String spaceName, String tagName, List<String> returnCols, int limit, long startTime, long endTime) {
        return this.scanVertex(spaceName, tagName, returnCols, limit, startTime, endTime, false, false);
    }

    public ScanVertexResultIterator scanVertex(String spaceName, int part, String tagName, List<String> returnCols, int limit, long startTime, long endTime) {
        return this.scanVertex(spaceName, part, tagName, returnCols, limit, startTime, endTime, false, false);
    }

    public ScanVertexResultIterator scanVertex(String spaceName, String tagName, int limit, long startTime, long endTime) {
        return this.scanVertex(spaceName, tagName, limit, startTime, endTime, false, false);
    }

    public ScanVertexResultIterator scanVertex(String spaceName, int part, String tagName, int limit, long startTime, long endTime) {
        return this.scanVertex(spaceName, part, tagName, new ArrayList<String>(), limit, startTime, endTime, false, false);
    }

    public ScanVertexResultIterator scanVertex(String spaceName, String tagName, List<String> returnCols, int limit, long startTime, long endTime, boolean allowPartSuccess, boolean allowReadFromFollower) {
        List<Integer> parts = this.metaManager.getSpaceParts(spaceName);
        if (parts.isEmpty()) {
            throw new IllegalArgumentException("No valid part in space " + spaceName);
        }
        return this.scanVertex(spaceName, parts, tagName, returnCols, false, limit, startTime, endTime, allowPartSuccess, allowReadFromFollower);
    }

    public ScanVertexResultIterator scanVertex(String spaceName, int part, String tagName, List<String> returnCols, int limit, long startTime, long endTime, boolean allowPartSuccess, boolean allowReadFromFollower) {
        return this.scanVertex(spaceName, Arrays.asList(part), tagName, returnCols, false, limit, startTime, endTime, allowPartSuccess, allowReadFromFollower);
    }

    public ScanVertexResultIterator scanVertex(String spaceName, String tagName, int limit, long startTime, long endTime, boolean allowPartSuccess, boolean allowReadFromFollower) {
        List<Integer> parts = this.metaManager.getSpaceParts(spaceName);
        if (parts.isEmpty()) {
            throw new IllegalArgumentException("No valid part in space " + spaceName);
        }
        return this.scanVertex(spaceName, parts, tagName, new ArrayList<String>(), true, limit, startTime, endTime, allowPartSuccess, allowReadFromFollower);
    }

    public ScanVertexResultIterator scanVertex(String spaceName, int part, String tagName, int limit, long startTime, long endTime, boolean allowPartSuccess, boolean allowReadFromFollower) {
        return this.scanVertex(spaceName, Arrays.asList(part), tagName, new ArrayList<String>(), true, limit, startTime, endTime, allowPartSuccess, allowReadFromFollower);
    }

    private ScanVertexResultIterator scanVertex(String spaceName, List<Integer> parts, String tagName, List<String> returnCols, boolean noColumns, int limit, long startTime, long endTime, boolean allowPartSuccess, boolean allowReadFromFollower) {
        if (spaceName == null || spaceName.trim().isEmpty()) {
            throw new IllegalArgumentException("space name is empty.");
        }
        if (tagName == null || tagName.trim().isEmpty()) {
            throw new IllegalArgumentException("tag name is empty");
        }
        if (noColumns && returnCols == null) {
            throw new IllegalArgumentException("returnCols is null");
        }
        HashSet<PartScanInfo> partScanInfoSet = new HashSet<PartScanInfo>();
        for (int part : parts) {
            HostAddr leader = this.metaManager.getLeader(spaceName, part);
            partScanInfoSet.add(new PartScanInfo(part, new HostAddress(leader.getHost(), leader.getPort())));
        }
        ArrayList<HostAddress> addrs = new ArrayList<HostAddress>();
        for (HostAddr addr : this.metaManager.listHosts()) {
            addrs.add(new HostAddress(addr.getHost(), addr.getPort()));
        }
        long tag = this.metaManager.getTag(spaceName, tagName).getTag_id();
        ArrayList<byte[]> props = new ArrayList<byte[]>();
        props.add("_vid".getBytes());
        if (!noColumns) {
            if (returnCols.size() == 0) {
                Schema schema = this.metaManager.getTag(spaceName, tagName).getSchema();
                for (ColumnDef columnDef : schema.getColumns()) {
                    props.add(columnDef.getName());
                }
            } else {
                for (String prop : returnCols) {
                    props.add(prop.getBytes());
                }
            }
        }
        VertexProp vertexCols = new VertexProp((int)tag, props);
        List<VertexProp> vertexProps = Arrays.asList(vertexCols);
        ScanVertexRequest request = new ScanVertexRequest();
        request.setSpace_id(this.getSpaceId(spaceName)).setReturn_columns(vertexProps).setLimit(limit).setStart_time(startTime).setEnd_time(endTime).setEnable_read_from_follower(allowReadFromFollower);
        return this.doScanVertex(spaceName, tagName, partScanInfoSet, request, addrs, allowPartSuccess);
    }

    private ScanVertexResultIterator doScanVertex(String spaceName, String tagName, Set<PartScanInfo> partScanInfoSet, ScanVertexRequest request, List<HostAddress> addrs, boolean allowPartSuccess) {
        if (addrs == null || addrs.isEmpty()) {
            throw new IllegalArgumentException("storage hosts is empty.");
        }
        return new ScanVertexResultIterator.ScanVertexResultBuilder().withMetaClient(this.metaManager).withPool(this.pool).withPartScanInfo(partScanInfoSet).withRequest(request).withAddresses(addrs).withSpaceName(spaceName).withTagName(tagName).withPartSuccess(allowPartSuccess).withUser(this.user).withPassword(this.password).withStorageAddressMapping(this.storageAddressMapping).build();
    }

    public ScanEdgeResultIterator scanEdge(String spaceName, String edgeName, List<String> returnCols) {
        return this.scanEdge(spaceName, edgeName, returnCols, 1000);
    }

    public ScanEdgeResultIterator scanEdge(String spaceName, int part, String edgeName, List<String> returnCols) {
        return this.scanEdge(spaceName, part, edgeName, returnCols, 1000);
    }

    public ScanEdgeResultIterator scanEdge(String spaceName, String edgeName) {
        return this.scanEdge(spaceName, edgeName, 1000);
    }

    public ScanEdgeResultIterator scanEdge(String spaceName, int part, String edgeName) {
        return this.scanEdge(spaceName, part, edgeName, 1000);
    }

    public ScanEdgeResultIterator scanEdge(String spaceName, String edgeName, List<String> returnCols, int limit) {
        return this.scanEdge(spaceName, edgeName, returnCols, limit, 0L, Long.MAX_VALUE);
    }

    public ScanEdgeResultIterator scanEdge(String spaceName, int part, String edgeName, List<String> returnCols, int limit) {
        return this.scanEdge(spaceName, part, edgeName, returnCols, limit, 0L, Long.MAX_VALUE);
    }

    public ScanEdgeResultIterator scanEdge(String spaceName, String edgeName, int limit) {
        return this.scanEdge(spaceName, edgeName, limit, 0L, Long.MAX_VALUE);
    }

    public ScanEdgeResultIterator scanEdge(String spaceName, int part, String edgeName, int limit) {
        return this.scanEdge(spaceName, part, edgeName, limit, 0L, Long.MAX_VALUE);
    }

    public ScanEdgeResultIterator scanEdge(String spaceName, String edgeName, List<String> returnCols, int limit, long startTime, long endTime) {
        return this.scanEdge(spaceName, edgeName, returnCols, limit, startTime, endTime, false, false);
    }

    public ScanEdgeResultIterator scanEdge(String spaceName, int part, String edgeName, List<String> returnCols, int limit, long startTime, long endTime) {
        return this.scanEdge(spaceName, part, edgeName, returnCols, limit, startTime, endTime, false, false);
    }

    public ScanEdgeResultIterator scanEdge(String spaceName, String edgeName, int limit, long startTime, long endTime) {
        return this.scanEdge(spaceName, edgeName, limit, startTime, endTime, false, false);
    }

    public ScanEdgeResultIterator scanEdge(String spaceName, int part, String edgeName, int limit, long startTime, long endTime) {
        return this.scanEdge(spaceName, part, edgeName, limit, startTime, endTime, false, false);
    }

    public ScanEdgeResultIterator scanEdge(String spaceName, String edgeName, List<String> returnCols, int limit, long startTime, long endTime, boolean allowPartSuccess, boolean allowReadFromFollower) {
        List<Integer> parts = this.metaManager.getSpaceParts(spaceName);
        if (parts.isEmpty()) {
            throw new IllegalArgumentException("No valid part in space " + spaceName);
        }
        return this.scanEdge(spaceName, parts, edgeName, returnCols, false, limit, startTime, endTime, allowPartSuccess, allowReadFromFollower);
    }

    public ScanEdgeResultIterator scanEdge(String spaceName, int part, String edgeName, List<String> returnCols, int limit, long startTime, long endTime, boolean allowPartSuccess, boolean allowReadFromFollower) {
        return this.scanEdge(spaceName, Arrays.asList(part), edgeName, returnCols, false, limit, startTime, endTime, allowPartSuccess, allowReadFromFollower);
    }

    public ScanEdgeResultIterator scanEdge(String spaceName, String edgeName, int limit, long startTime, long endTime, boolean allowPartSuccess, boolean allowReadFromFollower) {
        List<Integer> parts = this.metaManager.getSpaceParts(spaceName);
        if (parts.isEmpty()) {
            throw new IllegalArgumentException("No valid part in space " + spaceName);
        }
        return this.scanEdge(spaceName, parts, edgeName, new ArrayList<String>(), true, limit, startTime, endTime, allowPartSuccess, allowReadFromFollower);
    }

    public ScanEdgeResultIterator scanEdge(String spaceName, int part, String edgeName, int limit, long startTime, long endTime, boolean allowPartSuccess, boolean allowReadFromFollower) {
        return this.scanEdge(spaceName, Arrays.asList(part), edgeName, new ArrayList<String>(), true, limit, startTime, endTime, allowPartSuccess, allowReadFromFollower);
    }

    private ScanEdgeResultIterator scanEdge(String spaceName, List<Integer> parts, String edgeName, List<String> returnCols, boolean noColumns, int limit, long startTime, long endTime, boolean allowPartSuccess, boolean allowReadFromFollower) {
        if (spaceName == null || spaceName.trim().isEmpty()) {
            throw new IllegalArgumentException("space name is empty.");
        }
        if (edgeName == null || edgeName.trim().isEmpty()) {
            throw new IllegalArgumentException("edge name is empty");
        }
        if (noColumns && returnCols == null) {
            throw new IllegalArgumentException("returnCols is null");
        }
        HashSet<PartScanInfo> partScanInfoSet = new HashSet<PartScanInfo>();
        for (int part : parts) {
            HostAddr leader = this.metaManager.getLeader(spaceName, part);
            partScanInfoSet.add(new PartScanInfo(part, new HostAddress(leader.getHost(), leader.getPort())));
        }
        ArrayList<HostAddress> addrs = new ArrayList<HostAddress>();
        for (HostAddr addr : this.metaManager.listHosts()) {
            addrs.add(new HostAddress(addr.getHost(), addr.getPort()));
        }
        ArrayList<byte[]> props = new ArrayList<byte[]>();
        props.add("_src".getBytes());
        props.add("_dst".getBytes());
        props.add("_rank".getBytes());
        if (!noColumns) {
            if (returnCols.size() == 0) {
                Schema schema = this.metaManager.getEdge(spaceName, edgeName).getSchema();
                for (ColumnDef columnDef : schema.getColumns()) {
                    props.add(columnDef.name);
                }
            } else {
                for (String prop : returnCols) {
                    props.add(prop.getBytes());
                }
            }
        }
        long edgeId = this.getEdgeId(spaceName, edgeName);
        EdgeProp edgeCols = new EdgeProp((int)edgeId, props);
        List<EdgeProp> edgeProps = Arrays.asList(edgeCols);
        ScanEdgeRequest request = new ScanEdgeRequest();
        request.setSpace_id(this.getSpaceId(spaceName)).setReturn_columns(edgeProps).setLimit(limit).setStart_time(startTime).setEnd_time(endTime).setEnable_read_from_follower(allowReadFromFollower);
        return this.doScanEdge(spaceName, edgeName, partScanInfoSet, request, addrs, allowPartSuccess);
    }

    private ScanEdgeResultIterator doScanEdge(String spaceName, String edgeName, Set<PartScanInfo> partScanInfoSet, ScanEdgeRequest request, List<HostAddress> addrs, boolean allowPartSuccess) {
        if (addrs == null || addrs.isEmpty()) {
            throw new IllegalArgumentException("storage hosts is empty.");
        }
        return new ScanEdgeResultIterator.ScanEdgeResultBuilder().withMetaClient(this.metaManager).withPool(this.pool).withPartScanInfo(partScanInfoSet).withRequest(request).withAddresses(addrs).withSpaceName(spaceName).withEdgeName(edgeName).withPartSuccess(allowPartSuccess).withUser(this.user).withPassword(this.password).build();
    }

    public void close() {
        if (this.pool != null) {
            this.pool.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.metaManager != null) {
            this.metaManager.close();
        }
    }

    protected GraphStorageConnection getConnection() {
        return this.connection;
    }

    private int getSpaceId(String spaceName) {
        return this.metaManager.getSpaceId(spaceName);
    }

    private long getEdgeId(String spaceName, String edgeName) {
        return this.metaManager.getEdge(spaceName, edgeName).getEdge_type();
    }
}

