/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.net;

import com.vesoft.nebula.client.graph.NebulaPoolConfig;
import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.graph.exception.AuthFailedException;
import com.vesoft.nebula.client.graph.exception.ClientServerIncompatibleException;
import com.vesoft.nebula.client.graph.exception.IOErrorException;
import com.vesoft.nebula.client.graph.exception.InvalidConfigException;
import com.vesoft.nebula.client.graph.exception.NotValidConnectionException;
import com.vesoft.nebula.client.graph.net.AuthResult;
import com.vesoft.nebula.client.graph.net.ConnObjectPool;
import com.vesoft.nebula.client.graph.net.LoadBalancer;
import com.vesoft.nebula.client.graph.net.RoundRobinLoadBalancer;
import com.vesoft.nebula.client.graph.net.Session;
import com.vesoft.nebula.client.graph.net.SyncConnection;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NebulaPool
implements Serializable {
    private static final long serialVersionUID = 6226487268001127885L;
    private GenericObjectPool<SyncConnection> objectPool = null;
    private LoadBalancer loadBalancer;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private int waitTime = 0;
    private AtomicBoolean hasInit = new AtomicBoolean(false);
    private AtomicBoolean isClosed = new AtomicBoolean(false);

    private void checkConfig(NebulaPoolConfig config) {
        if (config.getIdleTime() < 0) {
            throw new InvalidConfigException("Config idleTime:" + config.getIdleTime() + " is illegal");
        }
        if (config.getMaxConnSize() <= 0) {
            throw new InvalidConfigException("Config maxConnSize:" + config.getMaxConnSize() + " is illegal");
        }
        if (config.getMinConnSize() < 0 || config.getMinConnSize() > config.getMaxConnSize()) {
            throw new InvalidConfigException("Config minConnSize:" + config.getMinConnSize() + " is illegal");
        }
        if (config.getTimeout() < 0) {
            throw new InvalidConfigException("Config timeout:" + config.getTimeout() + " is illegal");
        }
        if (config.getWaitTime() < 0) {
            throw new InvalidConfigException("Config waitTime:" + config.getWaitTime() + " is illegal");
        }
        if (config.getMinClusterHealthRate() < 0.0) {
            throw new InvalidConfigException("Config minClusterHealthRate:" + config.getMinClusterHealthRate() + " is illegal");
        }
    }

    public boolean init(List<HostAddress> addresses, NebulaPoolConfig config) throws UnknownHostException, InvalidConfigException {
        this.checkInit();
        this.hasInit.set(true);
        this.checkConfig(config);
        this.waitTime = config.getWaitTime();
        this.loadBalancer = config.isEnableSsl() ? new RoundRobinLoadBalancer(addresses, config.getTimeout(), config.getSslParam(), config.getMinClusterHealthRate(), config.isUseHttp2(), config.getCustomHeaders()) : new RoundRobinLoadBalancer(addresses, config.getTimeout(), config.getMinClusterHealthRate(), config.isUseHttp2(), config.getCustomHeaders());
        ConnObjectPool objectPool = new ConnObjectPool(this.loadBalancer, config);
        this.objectPool = new GenericObjectPool((PooledObjectFactory)objectPool);
        GenericObjectPoolConfig objConfig = new GenericObjectPoolConfig();
        objConfig.setMinIdle(config.getMinConnSize());
        objConfig.setMaxIdle(config.getMaxConnSize());
        objConfig.setMaxTotal(config.getMaxConnSize());
        objConfig.setTestOnBorrow(true);
        objConfig.setTestOnReturn(true);
        objConfig.setTestOnCreate(true);
        objConfig.setTestWhileIdle(true);
        objConfig.setTimeBetweenEvictionRunsMillis(config.getIntervalIdle() <= 0 ? -1L : (long)config.getIntervalIdle());
        objConfig.setSoftMinEvictableIdleTimeMillis(config.getIdleTime() <= 0 ? 1800000L : (long)config.getIdleTime());
        this.objectPool.setConfig(objConfig);
        AbandonedConfig abandonedConfig = new AbandonedConfig();
        abandonedConfig.setRemoveAbandonedOnBorrow(true);
        this.objectPool.setAbandonedConfig(abandonedConfig);
        return objectPool.init();
    }

    public void close() {
        if (this.isClosed.get()) {
            return;
        }
        this.isClosed.set(true);
        this.loadBalancer.close();
        this.objectPool.close();
    }

    public Session getSession(String userName, String password, boolean reconnect) throws NotValidConnectionException, IOErrorException, AuthFailedException, ClientServerIncompatibleException {
        this.checkNoInitAndClosed();
        SyncConnection connection = null;
        try {
            connection = this.getConnection();
            AuthResult authResult = connection.authenticate(userName, password);
            return new Session(connection, authResult, this, reconnect);
        }
        catch (Exception e) {
            if (connection != null) {
                this.setInvalidateConnection(connection);
            }
            throw e;
        }
    }

    public int getActiveConnNum() {
        this.checkNoInitAndClosed();
        return this.objectPool.getNumActive();
    }

    public int getIdleConnNum() {
        this.checkNoInitAndClosed();
        return this.objectPool.getNumIdle();
    }

    public int getWaitersNum() {
        this.checkNoInitAndClosed();
        return this.objectPool.getNumWaiters();
    }

    protected void updateServerStatus() {
        this.checkNoInitAndClosed();
        if (this.objectPool.getFactory() instanceof ConnObjectPool) {
            ((ConnObjectPool)this.objectPool.getFactory()).updateServerStatus();
        }
    }

    protected void setInvalidateConnection(SyncConnection connection) {
        this.checkNoInitAndClosed();
        try {
            this.objectPool.invalidateObject((Object)connection);
        }
        catch (Exception e) {
            this.log.error("Set invalidate object failed");
        }
    }

    protected void returnConnection(SyncConnection connection) {
        this.checkNoInitAndClosed();
        this.objectPool.returnObject((Object)connection);
    }

    protected SyncConnection getConnection() throws NotValidConnectionException {
        this.checkNoInitAndClosed();
        try {
            return (SyncConnection)this.objectPool.borrowObject((long)this.waitTime);
        }
        catch (Exception e) {
            throw new NotValidConnectionException(e.getMessage());
        }
    }

    private void checkNoInit() throws RuntimeException {
        if (!this.hasInit.get()) {
            throw new RuntimeException("The pool has not been initialized, please initialize it first.");
        }
    }

    private void checkInit() throws RuntimeException {
        if (this.hasInit.get()) {
            throw new RuntimeException("The pool has already been initialized. Please do not initialize the pool repeatedly.");
        }
    }

    private void checkNoInitAndClosed() throws RuntimeException {
        this.checkNoInit();
        this.checkClosed();
    }

    private void checkClosed() throws RuntimeException {
        if (this.isClosed.get()) {
            throw new RuntimeException("The pool has closed. Couldn't use again.");
        }
    }
}

