/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph;

import com.alibaba.fastjson.JSON;
import com.vesoft.nebula.ErrorCode;
import com.vesoft.nebula.client.graph.NebulaSession;
import com.vesoft.nebula.client.graph.SessionPoolConfig;
import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.graph.data.ResultSet;
import com.vesoft.nebula.client.graph.exception.AuthFailedException;
import com.vesoft.nebula.client.graph.exception.BindSpaceFailedException;
import com.vesoft.nebula.client.graph.exception.ClientServerIncompatibleException;
import com.vesoft.nebula.client.graph.exception.IOErrorException;
import com.vesoft.nebula.client.graph.net.AuthResult;
import com.vesoft.nebula.client.graph.net.SessionState;
import com.vesoft.nebula.client.graph.net.SyncConnection;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionPool
implements Serializable {
    private static final long serialVersionUID = 6051248334277617891L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ScheduledExecutorService healthCheckSchedule = Executors.newScheduledThreadPool(1);
    private final ScheduledExecutorService sessionQueueMaintainSchedule = Executors.newScheduledThreadPool(1);
    public CopyOnWriteArrayList<NebulaSession> sessionList = new CopyOnWriteArrayList();
    public AtomicInteger idleSessionSize = new AtomicInteger(0);
    public AtomicBoolean hasInit = new AtomicBoolean(false);
    public AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicInteger pos = new AtomicInteger(0);
    private final SessionPoolConfig sessionPoolConfig;
    private final int minSessionSize;
    private final int maxSessionSize;
    private final int cleanTime;
    private final int healthCheckTime;
    private final int retryTimes;
    private final int intervalTime;
    private final boolean reconnect;
    private final String spaceName;
    private final String useSpace;

    public SessionPool(SessionPoolConfig poolConfig) {
        this.sessionPoolConfig = poolConfig;
        this.minSessionSize = poolConfig.getMinSessionSize();
        this.maxSessionSize = poolConfig.getMaxSessionSize();
        this.cleanTime = poolConfig.getCleanTime();
        this.retryTimes = poolConfig.getRetryTimes();
        this.intervalTime = poolConfig.getIntervalTime();
        this.reconnect = poolConfig.isReconnect();
        this.healthCheckTime = poolConfig.getHealthCheckTime();
        this.spaceName = poolConfig.getSpaceName();
        this.useSpace = "USE `" + this.spaceName + "`;";
        this.init();
    }

    private synchronized NebulaSession getSession() throws ClientServerIncompatibleException, AuthFailedException, IOErrorException, BindSpaceFailedException {
        int retry = this.sessionPoolConfig.getRetryConnectTimes();
        while (retry-- >= 0) {
            if (this.idleSessionSize.get() > 0) {
                for (NebulaSession nebulaSession : this.sessionList) {
                    if (!nebulaSession.isIdleAndSetUsed()) continue;
                    this.idleSessionSize.decrementAndGet();
                    return nebulaSession;
                }
            }
            if (this.sessionList.size() < this.maxSessionSize) {
                return this.createSessionObject(SessionState.USED);
            }
            try {
                Thread.sleep(this.sessionPoolConfig.getWaitTime());
            }
            catch (InterruptedException e) {
                this.log.error("getSession error when wait for idle sessions, ", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("no extra session available");
    }

    @Deprecated
    public boolean init() {
        if (this.hasInit.get()) {
            return true;
        }
        while (this.sessionList.size() < this.minSessionSize) {
            try {
                this.createSessionObject(SessionState.IDLE);
                this.idleSessionSize.incrementAndGet();
            }
            catch (Exception e) {
                this.log.error("SessionPool init failed. ");
                throw new RuntimeException("create session failed.", e);
            }
        }
        this.healthCheckSchedule.scheduleAtFixedRate(this::checkSession, 0L, this.healthCheckTime, TimeUnit.SECONDS);
        this.sessionQueueMaintainSchedule.scheduleAtFixedRate(this::updateSessionQueue, 0L, this.cleanTime, TimeUnit.SECONDS);
        this.hasInit.compareAndSet(false, true);
        return true;
    }

    public ResultSet execute(String stmt) throws IOErrorException, ClientServerIncompatibleException, AuthFailedException, BindSpaceFailedException {
        this.stmtCheck(stmt);
        this.checkSessionPool();
        NebulaSession nebulaSession = null;
        ResultSet resultSet = null;
        int tryTimes = 0;
        while (tryTimes++ <= this.retryTimes) {
            try {
                nebulaSession = this.getSession();
                resultSet = nebulaSession.execute(stmt);
                if (resultSet.isSucceeded() || resultSet.getErrorCode() == ErrorCode.E_SEMANTIC_ERROR.getValue() || resultSet.getErrorCode() == ErrorCode.E_SYNTAX_ERROR.getValue()) {
                    this.releaseSession(nebulaSession);
                    return resultSet;
                }
                this.log.warn(String.format("execute error, code: %d, message: %s, retry: %d", resultSet.getErrorCode(), resultSet.getErrorMessage(), tryTimes));
                nebulaSession.release();
                this.sessionList.remove(nebulaSession);
                try {
                    Thread.sleep(this.intervalTime);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (ClientServerIncompatibleException clientServerIncompatibleException) {
            }
            catch (AuthFailedException | BindSpaceFailedException e) {
                throw e;
            }
            catch (IOErrorException e) {
                if (nebulaSession != null) {
                    nebulaSession.release();
                    this.sessionList.remove(nebulaSession);
                }
                if (tryTimes < this.retryTimes) {
                    this.log.warn(String.format("execute failed for IOErrorException, message: %s, retry: %d", e.getMessage(), tryTimes));
                    try {
                        Thread.sleep(this.intervalTime);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw e;
            }
        }
        if (nebulaSession != null) {
            nebulaSession.release();
            this.sessionList.remove(nebulaSession);
        }
        return resultSet;
    }

    public ResultSet execute(String stmt, Map<String, Object> parameterMap) throws ClientServerIncompatibleException, AuthFailedException, IOErrorException, BindSpaceFailedException {
        ResultSet resultSet;
        this.stmtCheck(stmt);
        this.checkSessionPool();
        NebulaSession nebulaSession = this.getSession();
        try {
            resultSet = nebulaSession.executeWithParameter(stmt, parameterMap);
            if (this.isSessionError(resultSet)) {
                this.sessionList.remove(nebulaSession);
                nebulaSession = this.getSession();
                resultSet = nebulaSession.executeWithParameter(stmt, parameterMap);
            }
        }
        catch (IOErrorException e) {
            this.useSpace(nebulaSession, null);
            throw e;
        }
        this.useSpace(nebulaSession, resultSet);
        return resultSet;
    }

    public ResultSet executeWithTimeout(String stmt, long timeoutMs) throws IOErrorException, AuthFailedException, BindSpaceFailedException {
        return this.executeWithParameterTimeout(stmt, Collections.EMPTY_MAP, timeoutMs);
    }

    public ResultSet executeWithParameterTimeout(String stmt, Map<String, Object> parameterMap, long timeoutMs) throws IOErrorException, AuthFailedException, BindSpaceFailedException {
        if (timeoutMs <= 0L) {
            throw new IllegalArgumentException("timeout should be a positive number");
        }
        this.stmtCheck(stmt);
        this.checkSessionPool();
        NebulaSession nebulaSession = null;
        ResultSet resultSet = null;
        int tryTimes = 0;
        while (tryTimes++ <= this.retryTimes) {
            try {
                nebulaSession = this.getSession();
                resultSet = nebulaSession.executeWithParameterTimeout(stmt, parameterMap, timeoutMs);
                if (resultSet.isSucceeded() || resultSet.getErrorCode() == ErrorCode.E_SEMANTIC_ERROR.getValue() || resultSet.getErrorCode() == ErrorCode.E_SYNTAX_ERROR.getValue()) {
                    this.releaseSession(nebulaSession);
                    return resultSet;
                }
                this.log.warn(String.format("execute error, code: %d, message: %s, retry: %d", resultSet.getErrorCode(), resultSet.getErrorMessage(), tryTimes));
                nebulaSession.release();
                this.sessionList.remove(nebulaSession);
                try {
                    Thread.sleep(this.intervalTime);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (ClientServerIncompatibleException clientServerIncompatibleException) {
            }
            catch (AuthFailedException | BindSpaceFailedException e) {
                throw e;
            }
            catch (IOErrorException e) {
                if (nebulaSession != null) {
                    nebulaSession.release();
                    this.sessionList.remove(nebulaSession);
                }
                if (tryTimes < this.retryTimes) {
                    this.log.warn(String.format("execute failed for IOErrorException, message: %s, retry: %d", e.getMessage(), tryTimes));
                    try {
                        Thread.sleep(this.intervalTime);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw e;
            }
        }
        if (nebulaSession != null) {
            nebulaSession.release();
            this.sessionList.remove(nebulaSession);
        }
        return resultSet;
    }

    public String executeJson(String stmt) throws ClientServerIncompatibleException, AuthFailedException, IOErrorException, BindSpaceFailedException {
        return this.executeJsonWithParameter(stmt, Collections.EMPTY_MAP);
    }

    public String executeJsonWithParameter(String stmt, Map<String, Object> parameterMap) throws ClientServerIncompatibleException, AuthFailedException, IOErrorException, BindSpaceFailedException {
        String result;
        this.stmtCheck(stmt);
        this.checkSessionPool();
        NebulaSession nebulaSession = this.getSession();
        try {
            result = nebulaSession.executeJsonWithParameter(stmt, parameterMap);
            if (this.isSessionErrorForJson(result)) {
                this.sessionList.remove(nebulaSession);
                nebulaSession = this.getSession();
                result = nebulaSession.executeJsonWithParameter(stmt, parameterMap);
            }
        }
        catch (IOErrorException e) {
            if (e.getType() == 2) {
                this.sessionList.remove(nebulaSession);
                nebulaSession = this.getSession();
                String result2 = nebulaSession.executeJsonWithParameter(stmt, parameterMap);
                return result2;
            }
            this.useSpace(nebulaSession, null);
            throw e;
        }
        this.useSpaceForJson(nebulaSession, result);
        return result;
    }

    public void close() {
        if (this.isClosed.get()) {
            return;
        }
        if (this.isClosed.compareAndSet(false, true)) {
            for (NebulaSession nebulaSession : this.sessionList) {
                nebulaSession.release();
            }
            this.sessionList.clear();
            if (!this.healthCheckSchedule.isShutdown()) {
                this.healthCheckSchedule.shutdown();
            }
            if (!this.sessionQueueMaintainSchedule.isShutdown()) {
                this.sessionQueueMaintainSchedule.shutdown();
            }
        }
    }

    public boolean isActive() {
        return this.hasInit.get();
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    public int getSessionNums() {
        return this.sessionList.size();
    }

    public int getIdleSessionNums() {
        return this.idleSessionSize.get();
    }

    private void releaseSession(NebulaSession nebulaSession) {
        nebulaSession.isUsedAndSetIdle();
        this.idleSessionSize.incrementAndGet();
    }

    private void checkSession() {
        for (NebulaSession nebulaSession : this.sessionList) {
            if (!nebulaSession.isIdleAndSetUsed()) continue;
            try {
                this.idleSessionSize.decrementAndGet();
                nebulaSession.execute("YIELD 1");
                nebulaSession.isUsedAndSetIdle();
                this.idleSessionSize.incrementAndGet();
            }
            catch (IOErrorException e) {
                this.log.error("session ping error, {}, remove current session.", (Object)e.getMessage());
                nebulaSession.release();
                this.sessionList.remove(nebulaSession);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSessionQueue() {
        if (this.idleSessionSize.get() > this.minSessionSize) {
            SessionPool sessionPool = this;
            synchronized (sessionPool) {
                for (NebulaSession nebulaSession : this.sessionList) {
                    if (!nebulaSession.isIdle().booleanValue()) continue;
                    nebulaSession.release();
                    this.sessionList.remove(nebulaSession);
                    if (this.idleSessionSize.decrementAndGet() > this.minSessionSize) continue;
                    break;
                }
            }
        }
    }

    private NebulaSession createSessionObject(SessionState state) throws ClientServerIncompatibleException, AuthFailedException, IOErrorException, BindSpaceFailedException {
        AuthResult authResult;
        SyncConnection connection = new SyncConnection();
        int tryConnect = this.sessionPoolConfig.getGraphAddressList().size();
        while (tryConnect-- > 0) {
            try {
                if (this.sessionPoolConfig.isEnableSsl()) {
                    connection.open(this.getAddress(), this.sessionPoolConfig.getTimeout(), this.sessionPoolConfig.getSslParam(), this.sessionPoolConfig.isUseHttp2(), this.sessionPoolConfig.getCustomHeaders());
                    break;
                }
                connection.open(this.getAddress(), this.sessionPoolConfig.getTimeout(), this.sessionPoolConfig.isUseHttp2(), this.sessionPoolConfig.getCustomHeaders());
                break;
            }
            catch (Exception e) {
                if (tryConnect == 0 || !this.reconnect) {
                    throw e;
                }
                this.log.warn("connect failed, " + e.getMessage());
            }
        }
        try {
            authResult = connection.authenticate(this.sessionPoolConfig.getUsername(), this.sessionPoolConfig.getPassword());
        }
        catch (AuthFailedException e) {
            this.log.error(e.getMessage());
            if (e.getMessage().toLowerCase().contains("user not exist") || e.getMessage().toLowerCase().contains("invalid password")) {
                this.close();
            } else {
                connection.close();
            }
            throw e;
        }
        NebulaSession nebulaSession = new NebulaSession(connection, authResult.getSessionId(), authResult.getTimezoneOffset(), state);
        ResultSet result = null;
        try {
            result = nebulaSession.execute(this.useSpace);
        }
        catch (IOErrorException e) {
            this.log.error("binding space failed,", (Throwable)e);
            nebulaSession.release();
            throw new BindSpaceFailedException("binding space failed:" + e.getMessage());
        }
        if (!result.isSucceeded()) {
            nebulaSession.release();
            throw new BindSpaceFailedException(result.getErrorMessage());
        }
        this.sessionList.add(nebulaSession);
        return nebulaSession;
    }

    public HostAddress getAddress() {
        List<HostAddress> addresses = this.sessionPoolConfig.getGraphAddressList();
        int newPos = this.pos.getAndIncrement() % addresses.size();
        return addresses.get(newPos);
    }

    private void useSpace(NebulaSession nebulaSession, ResultSet resultSet) throws IOErrorException {
        ResultSet switchSpaceResult;
        if (resultSet == null) {
            nebulaSession.release();
            this.sessionList.remove(nebulaSession);
            return;
        }
        if (resultSet.getSpaceName().trim().isEmpty()) {
            this.log.warn("space {} has been drop, close the SessionPool.", (Object)this.spaceName);
            this.close();
            return;
        }
        if (!this.spaceName.equals(resultSet.getSpaceName()) && !(switchSpaceResult = nebulaSession.execute(this.useSpace)).isSucceeded()) {
            this.log.warn("Bind Space failed, {}", (Object)switchSpaceResult.getErrorMessage());
            nebulaSession.release();
            this.sessionList.remove(nebulaSession);
            return;
        }
        this.releaseSession(nebulaSession);
    }

    private void useSpaceForJson(NebulaSession nebulaSession, String result) throws IOErrorException {
        String responseSpaceName = (String)JSON.parseObject((String)result).getJSONArray("results").getJSONObject(0).get((Object)"spaceName");
        if (!this.spaceName.equals(responseSpaceName)) {
            nebulaSession.execute(this.useSpace);
        }
        this.releaseSession(nebulaSession);
    }

    private boolean isSessionError(ResultSet resultSet) {
        return resultSet != null && (resultSet.getErrorCode() == ErrorCode.E_SESSION_INVALID.getValue() || resultSet.getErrorCode() == ErrorCode.E_SESSION_NOT_FOUND.getValue() || resultSet.getErrorCode() == ErrorCode.E_SESSION_TIMEOUT.getValue());
    }

    private boolean isSessionErrorForJson(String result) {
        if (result == null) {
            return true;
        }
        int code = JSON.parseObject((String)result).getJSONArray("errors").getJSONObject(0).getIntValue("code");
        return code == ErrorCode.E_SESSION_INVALID.getValue() || code == ErrorCode.E_SESSION_NOT_FOUND.getValue() || code == ErrorCode.E_SESSION_TIMEOUT.getValue();
    }

    private void checkSessionPool() {
        if (!this.hasInit.get()) {
            throw new RuntimeException("The SessionPool has not been initialized, please call init() first.");
        }
        if (this.isClosed.get()) {
            throw new RuntimeException("The SessionPool has been closed.");
        }
    }

    private void stmtCheck(String stmt) {
        if (stmt == null || stmt.trim().isEmpty()) {
            throw new IllegalArgumentException("statement is null.");
        }
        if (stmt.trim().toLowerCase().startsWith("use") && stmt.trim().split(" ").length == 2) {
            throw new IllegalArgumentException("`USE SPACE` alone is forbidden.");
        }
    }
}

