/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.data;

import com.vesoft.nebula.Value;
import com.vesoft.nebula.client.graph.data.DateTimeWrapper;
import com.vesoft.nebula.client.graph.data.DateWrapper;
import com.vesoft.nebula.client.graph.data.GeographyWrapper;
import com.vesoft.nebula.client.graph.data.Node;
import com.vesoft.nebula.client.graph.data.PathWrapper;
import com.vesoft.nebula.client.graph.data.Relationship;
import com.vesoft.nebula.client.graph.data.TimeWrapper;
import com.vesoft.nebula.client.graph.exception.InvalidValueException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;

public class ValueWrapper {
    private final Value value;
    private String decodeType = "utf-8";
    private int timezoneOffset = 0;

    private String descType() {
        switch (this.value.getSetField()) {
            case 1: {
                return "NULL";
            }
            case 2: {
                return "BOOLEAN";
            }
            case 3: {
                return "INT";
            }
            case 4: {
                return "FLOAT";
            }
            case 5: {
                return "STRING";
            }
            case 6: {
                return "DATE";
            }
            case 7: {
                return "TIME";
            }
            case 8: {
                return "DATETIME";
            }
            case 9: {
                return "VERTEX";
            }
            case 10: {
                return "EDGE";
            }
            case 11: {
                return "PATH";
            }
            case 12: {
                return "LIST";
            }
            case 13: {
                return "MAP";
            }
            case 14: {
                return "SET";
            }
            case 15: {
                return "DATASET";
            }
            case 16: {
                return "GEOGRAPHY";
            }
        }
        throw new IllegalArgumentException("Unknown field id " + this.value.getSetField());
    }

    public ValueWrapper(Value value, String decodeType) {
        this.value = value;
        this.decodeType = decodeType;
        this.timezoneOffset = 0;
    }

    public ValueWrapper(Value value, String decodeType, int timezoneOffset) {
        this.value = value;
        this.decodeType = decodeType;
        this.timezoneOffset = timezoneOffset;
    }

    public Value getValue() {
        return this.value;
    }

    public boolean isEmpty() {
        return this.value.getSetField() == 0;
    }

    public boolean isNull() {
        return this.value.getSetField() == 1;
    }

    public boolean isBoolean() {
        return this.value.getSetField() == 2;
    }

    public boolean isLong() {
        return this.value.getSetField() == 3;
    }

    public boolean isDouble() {
        return this.value.getSetField() == 4;
    }

    public boolean isString() {
        return this.value.getSetField() == 5;
    }

    public boolean isList() {
        return this.value.getSetField() == 12;
    }

    public boolean isSet() {
        return this.value.getSetField() == 14;
    }

    public boolean isMap() {
        return this.value.getSetField() == 13;
    }

    public boolean isTime() {
        return this.value.getSetField() == 7;
    }

    public boolean isDate() {
        return this.value.getSetField() == 6;
    }

    public boolean isDateTime() {
        return this.value.getSetField() == 8;
    }

    public boolean isVertex() {
        return this.value.getSetField() == 9;
    }

    public boolean isEdge() {
        return this.value.getSetField() == 10;
    }

    public boolean isPath() {
        return this.value.getSetField() == 11;
    }

    public boolean isGeography() {
        return this.value.getSetField() == 16;
    }

    public NullType asNull() throws InvalidValueException {
        if (this.value.getSetField() == 1) {
            return new NullType(((com.vesoft.nebula.NullType)this.value.getFieldValue()).getValue());
        }
        throw new InvalidValueException("Cannot get field nullType because value's type is " + this.descType());
    }

    public boolean asBoolean() throws InvalidValueException {
        if (this.value.getSetField() == 2) {
            return (Boolean)this.value.getFieldValue();
        }
        throw new InvalidValueException("Cannot get field boolean because value's type is " + this.descType());
    }

    public long asLong() throws InvalidValueException {
        if (this.value.getSetField() == 3) {
            return (Long)this.value.getFieldValue();
        }
        throw new InvalidValueException("Cannot get field long because value's type is " + this.descType());
    }

    public String asString() throws InvalidValueException, UnsupportedEncodingException {
        if (this.value.getSetField() == 5) {
            return new String((byte[])this.value.getFieldValue(), this.decodeType);
        }
        throw new InvalidValueException("Cannot get field string because value's type is " + this.descType());
    }

    public double asDouble() throws InvalidValueException {
        if (this.value.getSetField() == 4) {
            return (Double)this.value.getFieldValue();
        }
        throw new InvalidValueException("Cannot get field double because value's type is " + this.descType());
    }

    public ArrayList<ValueWrapper> asList() throws InvalidValueException {
        if (this.value.getSetField() != 12) {
            throw new InvalidValueException("Cannot get field type `list' because value's type is " + this.descType());
        }
        ArrayList<ValueWrapper> values = new ArrayList<ValueWrapper>();
        for (Value value : this.value.getLVal().getValues()) {
            values.add(new ValueWrapper(value, this.decodeType, this.timezoneOffset));
        }
        return values;
    }

    public HashSet<ValueWrapper> asSet() throws InvalidValueException {
        if (this.value.getSetField() != 14) {
            throw new InvalidValueException("Cannot get field type `set' because value's type is " + this.descType());
        }
        HashSet<ValueWrapper> values = new HashSet<ValueWrapper>();
        for (Value value : this.value.getUVal().getValues()) {
            values.add(new ValueWrapper(value, this.decodeType, this.timezoneOffset));
        }
        return values;
    }

    public HashMap<String, ValueWrapper> asMap() throws InvalidValueException, UnsupportedEncodingException {
        if (this.value.getSetField() != 13) {
            throw new InvalidValueException("Cannot get field type `set' because value's type is " + this.descType());
        }
        HashMap<String, ValueWrapper> kvs = new HashMap<String, ValueWrapper>();
        Map<byte[], Value> inValues = this.value.getMVal().getKvs();
        for (byte[] key : inValues.keySet()) {
            kvs.put(new String(key, this.decodeType), new ValueWrapper(inValues.get(key), this.decodeType, this.timezoneOffset));
        }
        return kvs;
    }

    public TimeWrapper asTime() throws InvalidValueException {
        if (this.value.getSetField() == 7) {
            return (TimeWrapper)new TimeWrapper(this.value.getTVal()).setDecodeType(this.decodeType).setTimezoneOffset(this.timezoneOffset);
        }
        throw new InvalidValueException("Cannot get field time because value's type is " + this.descType());
    }

    public DateWrapper asDate() throws InvalidValueException {
        if (this.value.getSetField() == 6) {
            return new DateWrapper(this.value.getDVal());
        }
        throw new InvalidValueException("Cannot get field date because value's type is " + this.descType());
    }

    public DateTimeWrapper asDateTime() throws InvalidValueException {
        if (this.value.getSetField() == 8) {
            return (DateTimeWrapper)new DateTimeWrapper(this.value.getDtVal()).setDecodeType(this.decodeType).setTimezoneOffset(this.timezoneOffset);
        }
        throw new InvalidValueException("Cannot get field datetime because value's type is " + this.descType());
    }

    public Node asNode() throws InvalidValueException, UnsupportedEncodingException {
        if (this.value.getSetField() == 9) {
            return (Node)new Node(this.value.getVVal()).setDecodeType(this.decodeType).setTimezoneOffset(this.timezoneOffset);
        }
        throw new InvalidValueException("Cannot get field Node because value's type is " + this.descType());
    }

    public Relationship asRelationship() throws InvalidValueException {
        if (this.value.getSetField() == 10) {
            return (Relationship)new Relationship(this.value.getEVal()).setDecodeType(this.decodeType).setTimezoneOffset(this.timezoneOffset);
        }
        throw new InvalidValueException("Cannot get field Relationship because value's type is " + this.descType());
    }

    public PathWrapper asPath() throws InvalidValueException, UnsupportedEncodingException {
        if (this.value.getSetField() == 11) {
            return (PathWrapper)new PathWrapper(this.value.getPVal()).setDecodeType(this.decodeType).setTimezoneOffset(this.timezoneOffset);
        }
        throw new InvalidValueException("Cannot get field PathWrapper because value's type is " + this.descType());
    }

    public GeographyWrapper asGeography() throws InvalidValueException {
        if (this.value.getSetField() == 16) {
            return (GeographyWrapper)new GeographyWrapper(this.value.getGgVal()).setDecodeType(this.decodeType).setTimezoneOffset(this.timezoneOffset);
        }
        throw new InvalidValueException("Cannot get field GeographyWrapper because value's type is " + this.descType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueWrapper that = (ValueWrapper)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.decodeType, that.decodeType);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.decodeType);
    }

    public String toString() {
        try {
            if (this.isEmpty()) {
                return "__EMPTY__";
            }
            if (this.isNull()) {
                return this.asNull().toString();
            }
            if (this.isBoolean()) {
                return String.valueOf(this.asBoolean());
            }
            if (this.isLong()) {
                return String.valueOf(this.asLong());
            }
            if (this.isDouble()) {
                return String.valueOf(this.asDouble());
            }
            if (this.isString()) {
                return "\"" + this.asString() + "\"";
            }
            if (this.isList()) {
                return this.asList().toString();
            }
            if (this.isSet()) {
                return this.asSet().toString();
            }
            if (this.isMap()) {
                return this.asMap().toString();
            }
            if (this.isTime()) {
                return this.asTime().toString();
            }
            if (this.isDate()) {
                return this.asDate().toString();
            }
            if (this.isDateTime()) {
                return this.asDateTime().toString();
            }
            if (this.isVertex()) {
                return this.asNode().toString();
            }
            if (this.isEdge()) {
                return this.asRelationship().toString();
            }
            if (this.isPath()) {
                return this.asPath().toString();
            }
            if (this.isGeography()) {
                return this.asGeography().toString();
            }
            return "Unknown type: " + this.descType();
        }
        catch (UnsupportedEncodingException e) {
            return e.getMessage();
        }
    }

    public static class NullType {
        public static final int __NULL__ = 0;
        public static final int NaN = 1;
        public static final int BAD_DATA = 2;
        public static final int BAD_TYPE = 3;
        public static final int ERR_OVERFLOW = 4;
        public static final int UNKNOWN_PROP = 5;
        public static final int DIV_BY_ZERO = 6;
        public static final int OUT_OF_RANGE = 7;
        int nullType;

        public NullType(int nullType) {
            this.nullType = nullType;
        }

        public int getNullType() {
            return this.nullType;
        }

        public String toString() {
            switch (this.nullType) {
                case 0: {
                    return "NULL";
                }
                case 1: {
                    return "NaN";
                }
                case 2: {
                    return "BAD_DATA";
                }
                case 3: {
                    return "BAD_TYPE";
                }
                case 4: {
                    return "ERR_OVERFLOW";
                }
                case 5: {
                    return "UNKNOWN_PROP";
                }
                case 6: {
                    return "DIV_BY_ZERO";
                }
                case 7: {
                    return "OUT_OF_RANGE";
                }
            }
            return "Unknown type: " + this.nullType;
        }
    }
}

