/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.DirInfo;
import com.vesoft.nebula.HostAddr;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class NodeInfo
implements TBase,
Serializable,
Cloneable,
Comparable<NodeInfo> {
    private static final TStruct STRUCT_DESC = new TStruct("NodeInfo");
    private static final TField HOST_FIELD_DESC = new TField("host", 12, 1);
    private static final TField DIR_FIELD_DESC = new TField("dir", 12, 2);
    public HostAddr host;
    public DirInfo dir;
    public static final int HOST = 1;
    public static final int DIR = 2;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public NodeInfo() {
    }

    public NodeInfo(HostAddr host, DirInfo dir) {
        this();
        this.host = host;
        this.dir = dir;
    }

    public static Builder builder() {
        return new Builder();
    }

    public NodeInfo(NodeInfo other) {
        if (other.isSetHost()) {
            this.host = TBaseHelper.deepCopy(other.host);
        }
        if (other.isSetDir()) {
            this.dir = TBaseHelper.deepCopy(other.dir);
        }
    }

    @Override
    public NodeInfo deepCopy() {
        return new NodeInfo(this);
    }

    public HostAddr getHost() {
        return this.host;
    }

    public NodeInfo setHost(HostAddr host) {
        this.host = host;
        return this;
    }

    public void unsetHost() {
        this.host = null;
    }

    public boolean isSetHost() {
        return this.host != null;
    }

    public void setHostIsSet(boolean __value) {
        if (!__value) {
            this.host = null;
        }
    }

    public DirInfo getDir() {
        return this.dir;
    }

    public NodeInfo setDir(DirInfo dir) {
        this.dir = dir;
        return this;
    }

    public void unsetDir() {
        this.dir = null;
    }

    public boolean isSetDir() {
        return this.dir != null;
    }

    public void setDirIsSet(boolean __value) {
        if (!__value) {
            this.dir = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetHost();
                    break;
                }
                this.setHost((HostAddr)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetDir();
                    break;
                }
                this.setDir((DirInfo)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getHost();
            }
            case 2: {
                return this.getDir();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof NodeInfo)) {
            return false;
        }
        NodeInfo that = (NodeInfo)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetHost(), that.isSetHost(), this.host, that.host)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetDir(), that.isSetDir(), this.dir, that.dir);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.host, this.dir});
    }

    @Override
    public int compareTo(NodeInfo other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetHost()).compareTo(other.isSetHost());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.host, other.host);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDir()).compareTo(other.isSetDir());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.dir, other.dir);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 12) {
                        this.host = new HostAddr();
                        this.host.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 12) {
                        this.dir = new DirInfo();
                        this.dir.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.host != null) {
            oprot.writeFieldBegin(HOST_FIELD_DESC);
            this.host.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.dir != null) {
            oprot.writeFieldBegin(DIR_FIELD_DESC);
            this.dir.write(oprot);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("NodeInfo");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("host");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getHost() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getHost(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("dir");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getDir() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getDir(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("host", 3, new StructMetaData(12, HostAddr.class)));
        tmpMetaDataMap.put(2, new FieldMetaData("dir", 3, new StructMetaData(12, DirInfo.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(NodeInfo.class, metaDataMap);
    }

    public static class Builder {
        private HostAddr host;
        private DirInfo dir;

        public Builder setHost(HostAddr host) {
            this.host = host;
            return this;
        }

        public Builder setDir(DirInfo dir) {
            this.dir = dir;
            return this;
        }

        public NodeInfo build() {
            NodeInfo result = new NodeInfo();
            result.setHost(this.host);
            result.setDir(this.dir);
            return result;
        }
    }
}

