/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.MapMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.meta.HostRole;
import com.vesoft.nebula.meta.LeaderInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HBReq
implements TBase,
Serializable,
Cloneable,
Comparable<HBReq> {
    private static final TStruct STRUCT_DESC = new TStruct("HBReq");
    private static final TField ROLE_FIELD_DESC = new TField("role", 8, 1);
    private static final TField HOST_FIELD_DESC = new TField("host", 12, 2);
    private static final TField CLUSTER_ID_FIELD_DESC = new TField("cluster_id", 10, 3);
    private static final TField LEADER_PART_IDS_FIELD_DESC = new TField("leader_partIds", 13, 4);
    private static final TField GIT_INFO_SHA_FIELD_DESC = new TField("git_info_sha", 11, 5);
    private static final TField VERSION_FIELD_DESC = new TField("version", 11, 6);
    public HostRole role;
    public HostAddr host;
    public long cluster_id;
    public Map<Integer, List<LeaderInfo>> leader_partIds;
    public byte[] git_info_sha;
    public byte[] version;
    public static final int ROLE = 1;
    public static final int HOST = 2;
    public static final int CLUSTER_ID = 3;
    public static final int LEADER_PARTIDS = 4;
    public static final int GIT_INFO_SHA = 5;
    public static final int VERSION = 6;
    private static final int __CLUSTER_ID_ISSET_ID = 0;
    private BitSet __isset_bit_vector = new BitSet(1);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public HBReq() {
    }

    public HBReq(HostRole role, HostAddr host, long cluster_id, byte[] git_info_sha) {
        this();
        this.role = role;
        this.host = host;
        this.cluster_id = cluster_id;
        this.setCluster_idIsSet(true);
        this.git_info_sha = git_info_sha;
    }

    public HBReq(HostRole role, HostAddr host, long cluster_id, Map<Integer, List<LeaderInfo>> leader_partIds, byte[] git_info_sha, byte[] version) {
        this();
        this.role = role;
        this.host = host;
        this.cluster_id = cluster_id;
        this.setCluster_idIsSet(true);
        this.leader_partIds = leader_partIds;
        this.git_info_sha = git_info_sha;
        this.version = version;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HBReq(HBReq other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        if (other.isSetRole()) {
            this.role = TBaseHelper.deepCopy(other.role);
        }
        if (other.isSetHost()) {
            this.host = TBaseHelper.deepCopy(other.host);
        }
        this.cluster_id = TBaseHelper.deepCopy(other.cluster_id);
        if (other.isSetLeader_partIds()) {
            this.leader_partIds = TBaseHelper.deepCopy(other.leader_partIds);
        }
        if (other.isSetGit_info_sha()) {
            this.git_info_sha = TBaseHelper.deepCopy(other.git_info_sha);
        }
        if (other.isSetVersion()) {
            this.version = TBaseHelper.deepCopy(other.version);
        }
    }

    @Override
    public HBReq deepCopy() {
        return new HBReq(this);
    }

    public HostRole getRole() {
        return this.role;
    }

    public HBReq setRole(HostRole role) {
        this.role = role;
        return this;
    }

    public void unsetRole() {
        this.role = null;
    }

    public boolean isSetRole() {
        return this.role != null;
    }

    public void setRoleIsSet(boolean __value) {
        if (!__value) {
            this.role = null;
        }
    }

    public HostAddr getHost() {
        return this.host;
    }

    public HBReq setHost(HostAddr host) {
        this.host = host;
        return this;
    }

    public void unsetHost() {
        this.host = null;
    }

    public boolean isSetHost() {
        return this.host != null;
    }

    public void setHostIsSet(boolean __value) {
        if (!__value) {
            this.host = null;
        }
    }

    public long getCluster_id() {
        return this.cluster_id;
    }

    public HBReq setCluster_id(long cluster_id) {
        this.cluster_id = cluster_id;
        this.setCluster_idIsSet(true);
        return this;
    }

    public void unsetCluster_id() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetCluster_id() {
        return this.__isset_bit_vector.get(0);
    }

    public void setCluster_idIsSet(boolean __value) {
        this.__isset_bit_vector.set(0, __value);
    }

    public Map<Integer, List<LeaderInfo>> getLeader_partIds() {
        return this.leader_partIds;
    }

    public HBReq setLeader_partIds(Map<Integer, List<LeaderInfo>> leader_partIds) {
        this.leader_partIds = leader_partIds;
        return this;
    }

    public void unsetLeader_partIds() {
        this.leader_partIds = null;
    }

    public boolean isSetLeader_partIds() {
        return this.leader_partIds != null;
    }

    public void setLeader_partIdsIsSet(boolean __value) {
        if (!__value) {
            this.leader_partIds = null;
        }
    }

    public byte[] getGit_info_sha() {
        return this.git_info_sha;
    }

    public HBReq setGit_info_sha(byte[] git_info_sha) {
        this.git_info_sha = git_info_sha;
        return this;
    }

    public void unsetGit_info_sha() {
        this.git_info_sha = null;
    }

    public boolean isSetGit_info_sha() {
        return this.git_info_sha != null;
    }

    public void setGit_info_shaIsSet(boolean __value) {
        if (!__value) {
            this.git_info_sha = null;
        }
    }

    public byte[] getVersion() {
        return this.version;
    }

    public HBReq setVersion(byte[] version) {
        this.version = version;
        return this;
    }

    public void unsetVersion() {
        this.version = null;
    }

    public boolean isSetVersion() {
        return this.version != null;
    }

    public void setVersionIsSet(boolean __value) {
        if (!__value) {
            this.version = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetRole();
                    break;
                }
                this.setRole((HostRole)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetHost();
                    break;
                }
                this.setHost((HostAddr)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetCluster_id();
                    break;
                }
                this.setCluster_id((Long)__value);
                break;
            }
            case 4: {
                if (__value == null) {
                    this.unsetLeader_partIds();
                    break;
                }
                this.setLeader_partIds((Map)__value);
                break;
            }
            case 5: {
                if (__value == null) {
                    this.unsetGit_info_sha();
                    break;
                }
                this.setGit_info_sha((byte[])__value);
                break;
            }
            case 6: {
                if (__value == null) {
                    this.unsetVersion();
                    break;
                }
                this.setVersion((byte[])__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getRole();
            }
            case 2: {
                return this.getHost();
            }
            case 3: {
                return new Long(this.getCluster_id());
            }
            case 4: {
                return this.getLeader_partIds();
            }
            case 5: {
                return this.getGit_info_sha();
            }
            case 6: {
                return this.getVersion();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof HBReq)) {
            return false;
        }
        HBReq that = (HBReq)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetRole(), that.isSetRole(), this.role, that.role)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetHost(), that.isSetHost(), this.host, that.host)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.cluster_id, that.cluster_id)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetLeader_partIds(), that.isSetLeader_partIds(), this.leader_partIds, that.leader_partIds)) {
            return false;
        }
        if (!TBaseHelper.equalsSlow(this.isSetGit_info_sha(), that.isSetGit_info_sha(), this.git_info_sha, that.git_info_sha)) {
            return false;
        }
        return TBaseHelper.equalsSlow(this.isSetVersion(), that.isSetVersion(), this.version, that.version);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.role, this.host, this.cluster_id, this.leader_partIds, this.git_info_sha, this.version});
    }

    @Override
    public int compareTo(HBReq other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetRole()).compareTo(other.isSetRole());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.role, other.role);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetHost()).compareTo(other.isSetHost());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.host, other.host);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCluster_id()).compareTo(other.isSetCluster_id());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.cluster_id, other.cluster_id);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLeader_partIds()).compareTo(other.isSetLeader_partIds());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.leader_partIds, other.leader_partIds);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetGit_info_sha()).compareTo(other.isSetGit_info_sha());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.git_info_sha, other.git_info_sha);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetVersion()).compareTo(other.isSetVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.version, other.version);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 8) {
                        this.role = HostRole.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 12) {
                        this.host = new HostAddr();
                        this.host.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 10) {
                        this.cluster_id = iprot.readI64();
                        this.setCluster_idIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 4: {
                    if (__field.type == 13) {
                        TMap _map140 = iprot.readMapBegin();
                        this.leader_partIds = new HashMap<Integer, List<LeaderInfo>>(Math.max(0, 2 * _map140.size));
                        int _i141 = 0;
                        while (_map140.size < 0 ? iprot.peekMap() : _i141 < _map140.size) {
                            int _key142 = iprot.readI32();
                            TList _list144 = iprot.readListBegin();
                            ArrayList<LeaderInfo> _val143 = new ArrayList<LeaderInfo>(Math.max(0, _list144.size));
                            int _i145 = 0;
                            while (_list144.size < 0 ? iprot.peekList() : _i145 < _list144.size) {
                                LeaderInfo _elem146 = new LeaderInfo();
                                _elem146.read(iprot);
                                _val143.add(_elem146);
                                ++_i145;
                            }
                            iprot.readListEnd();
                            this.leader_partIds.put(_key142, _val143);
                            ++_i141;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 5: {
                    if (__field.type == 11) {
                        this.git_info_sha = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 6: {
                    if (__field.type == 11) {
                        this.version = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.role != null) {
            oprot.writeFieldBegin(ROLE_FIELD_DESC);
            oprot.writeI32(this.role == null ? 0 : this.role.getValue());
            oprot.writeFieldEnd();
        }
        if (this.host != null) {
            oprot.writeFieldBegin(HOST_FIELD_DESC);
            this.host.write(oprot);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(CLUSTER_ID_FIELD_DESC);
        oprot.writeI64(this.cluster_id);
        oprot.writeFieldEnd();
        if (this.leader_partIds != null && this.isSetLeader_partIds()) {
            oprot.writeFieldBegin(LEADER_PART_IDS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(8, 15, this.leader_partIds.size()));
            for (Map.Entry<Integer, List<LeaderInfo>> _iter147 : this.leader_partIds.entrySet()) {
                oprot.writeI32(_iter147.getKey());
                oprot.writeListBegin(new TList(12, _iter147.getValue().size()));
                for (LeaderInfo _iter148 : _iter147.getValue()) {
                    _iter148.write(oprot);
                }
                oprot.writeListEnd();
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        if (this.git_info_sha != null) {
            oprot.writeFieldBegin(GIT_INFO_SHA_FIELD_DESC);
            oprot.writeBinary(this.git_info_sha);
            oprot.writeFieldEnd();
        }
        if (this.version != null && this.isSetVersion()) {
            oprot.writeFieldBegin(VERSION_FIELD_DESC);
            oprot.writeBinary(this.version);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        int i;
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("HBReq");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("role");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getRole() == null) {
            sb.append("null");
        } else {
            String role_name;
            String string = role_name = this.getRole() == null ? "null" : this.getRole().name();
            if (role_name != null) {
                sb.append(role_name);
                sb.append(" (");
            }
            sb.append(this.getRole());
            if (role_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("host");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getHost() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getHost(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("cluster_id");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getCluster_id(), indent + 1, prettyPrint));
        first = false;
        if (this.isSetLeader_partIds()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("leader_partIds");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getLeader_partIds() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getLeader_partIds(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("git_info_sha");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getGit_info_sha() == null) {
            sb.append("null");
        } else {
            int __git_info_sha_size = Math.min(this.getGit_info_sha().length, 128);
            for (i = 0; i < __git_info_sha_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getGit_info_sha()[i]).length() > 1 ? Integer.toHexString(this.getGit_info_sha()[i]).substring(Integer.toHexString(this.getGit_info_sha()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getGit_info_sha()[i]).toUpperCase());
            }
            if (this.getGit_info_sha().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (this.isSetVersion()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("version");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getVersion() == null) {
                sb.append("null");
            } else {
                int __version_size = Math.min(this.getVersion().length, 128);
                for (i = 0; i < __version_size; ++i) {
                    if (i != 0) {
                        sb.append(" ");
                    }
                    sb.append(Integer.toHexString(this.getVersion()[i]).length() > 1 ? Integer.toHexString(this.getVersion()[i]).substring(Integer.toHexString(this.getVersion()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getVersion()[i]).toUpperCase());
                }
                if (this.getVersion().length > 128) {
                    sb.append(" ...");
                }
            }
            first = false;
        }
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("role", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("host", 3, new StructMetaData(12, HostAddr.class)));
        tmpMetaDataMap.put(3, new FieldMetaData("cluster_id", 3, new FieldValueMetaData(10)));
        tmpMetaDataMap.put(4, new FieldMetaData("leader_partIds", 2, new MapMetaData(13, new FieldValueMetaData(8), new ListMetaData(15, new StructMetaData(12, LeaderInfo.class)))));
        tmpMetaDataMap.put(5, new FieldMetaData("git_info_sha", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(6, new FieldMetaData("version", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(HBReq.class, metaDataMap);
    }

    public static class Builder {
        private HostRole role;
        private HostAddr host;
        private long cluster_id;
        private Map<Integer, List<LeaderInfo>> leader_partIds;
        private byte[] git_info_sha;
        private byte[] version;
        BitSet __optional_isset = new BitSet(1);

        public Builder setRole(HostRole role) {
            this.role = role;
            return this;
        }

        public Builder setHost(HostAddr host) {
            this.host = host;
            return this;
        }

        public Builder setCluster_id(long cluster_id) {
            this.cluster_id = cluster_id;
            this.__optional_isset.set(0, true);
            return this;
        }

        public Builder setLeader_partIds(Map<Integer, List<LeaderInfo>> leader_partIds) {
            this.leader_partIds = leader_partIds;
            return this;
        }

        public Builder setGit_info_sha(byte[] git_info_sha) {
            this.git_info_sha = git_info_sha;
            return this;
        }

        public Builder setVersion(byte[] version) {
            this.version = version;
            return this;
        }

        public HBReq build() {
            HBReq result = new HBReq();
            result.setRole(this.role);
            result.setHost(this.host);
            if (this.__optional_isset.get(0)) {
                result.setCluster_id(this.cluster_id);
            }
            result.setLeader_partIds(this.leader_partIds);
            result.setGit_info_sha(this.git_info_sha);
            result.setVersion(this.version);
            return result;
        }
    }
}

