/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.meta;

import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TCompactProtocol;
import com.facebook.thrift.transport.TSocket;
import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.meta.AbstractMetaClient;
import com.vesoft.nebula.client.meta.exception.ExecuteFailedException;
import com.vesoft.nebula.meta.EdgeItem;
import com.vesoft.nebula.meta.ErrorCode;
import com.vesoft.nebula.meta.GetEdgeReq;
import com.vesoft.nebula.meta.GetEdgeResp;
import com.vesoft.nebula.meta.GetPartsAllocReq;
import com.vesoft.nebula.meta.GetPartsAllocResp;
import com.vesoft.nebula.meta.GetSpaceReq;
import com.vesoft.nebula.meta.GetSpaceResp;
import com.vesoft.nebula.meta.GetTagReq;
import com.vesoft.nebula.meta.GetTagResp;
import com.vesoft.nebula.meta.HostItem;
import com.vesoft.nebula.meta.IdName;
import com.vesoft.nebula.meta.ListEdgesReq;
import com.vesoft.nebula.meta.ListEdgesResp;
import com.vesoft.nebula.meta.ListHostsReq;
import com.vesoft.nebula.meta.ListHostsResp;
import com.vesoft.nebula.meta.ListSpacesReq;
import com.vesoft.nebula.meta.ListSpacesResp;
import com.vesoft.nebula.meta.ListTagsReq;
import com.vesoft.nebula.meta.ListTagsResp;
import com.vesoft.nebula.meta.MetaService;
import com.vesoft.nebula.meta.Schema;
import com.vesoft.nebula.meta.SpaceItem;
import com.vesoft.nebula.meta.TagItem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaClient
extends AbstractMetaClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaClient.class);
    public static final int LATEST_SCHEMA_VERSION = -1;
    private static final int DEFAULT_TIMEOUT_MS = 1000;
    private static final int DEFAULT_CONNECTION_RETRY_SIZE = 3;
    private static final int DEFAULT_EXECUTION_RETRY_SIZE = 3;
    private MetaService.Client client;
    private final List<HostAddress> addresses;

    public MetaClient(String host, int port) {
        this(new HostAddress(host, port));
    }

    public MetaClient(HostAddress address) {
        this(Arrays.asList(address), 3, 3);
    }

    public MetaClient(List<HostAddress> addresses) {
        this(addresses, 3, 3);
    }

    public MetaClient(List<HostAddress> addresses, int connectionRetry, int executionRetry) {
        this(addresses, 1000, connectionRetry, executionRetry);
    }

    public MetaClient(List<HostAddress> addresses, int timeout, int connectionRetry, int executionRetry) {
        super(addresses, timeout, connectionRetry, executionRetry);
        this.addresses = addresses;
    }

    public void connect() throws TException {
        this.doConnect();
    }

    private void doConnect() throws TException {
        Random random = new Random(System.currentTimeMillis());
        int position = random.nextInt(this.addresses.size());
        HostAddress address = this.addresses.get(position);
        this.transport = new TSocket(address.getHost(), address.getPort(), this.timeout, this.timeout);
        this.transport.open();
        this.protocol = new TCompactProtocol(this.transport);
        this.client = new MetaService.Client(this.protocol);
    }

    public void close() {
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
        }
    }

    public synchronized List<IdName> getSpaces() throws TException {
        ListSpacesReq request = new ListSpacesReq();
        ListSpacesResp response = this.client.listSpaces(request);
        return response.getSpaces();
    }

    public synchronized SpaceItem getSpace(String spaceName) throws TException {
        GetSpaceReq request = new GetSpaceReq();
        request.setSpace_name(spaceName.getBytes());
        GetSpaceResp response = this.client.getSpace(request);
        return response.getItem();
    }

    public synchronized List<TagItem> getTags(String spaceName) throws TException, ExecuteFailedException {
        ListTagsResp response;
        int spaceID = this.getSpace((String)spaceName).space_id;
        ListTagsReq request = new ListTagsReq(spaceID);
        try {
            response = this.client.listTags(request);
        }
        catch (TException e) {
            LOGGER.error(String.format("Get Tag Error: %s", e.getMessage()));
            throw e;
        }
        if (response.getCode() == 0) {
            return response.getTags();
        }
        LOGGER.error(String.format("Get tags Error: %s", response.getCode()));
        throw new ExecuteFailedException("Get Tags Error:" + ErrorCode.VALUES_TO_NAMES.get(response.getCode()));
    }

    public synchronized Schema getTag(String spaceName, String tagName) throws TException, ExecuteFailedException {
        GetTagResp response;
        GetTagReq request = new GetTagReq();
        int spaceID = this.getSpace(spaceName).getSpace_id();
        request.setSpace_id(spaceID);
        request.setTag_name(tagName.getBytes());
        request.setVersion(-1L);
        try {
            response = this.client.getTag(request);
        }
        catch (TException e) {
            LOGGER.error(String.format("Get Tag Error: %s", e.getMessage()));
            throw e;
        }
        if (response.getCode() == 0) {
            return response.getSchema();
        }
        LOGGER.error(String.format("Get tag execute Error: %s", ErrorCode.VALUES_TO_NAMES.get(response.getCode())));
        throw new ExecuteFailedException("Get tag execute Error: " + ErrorCode.VALUES_TO_NAMES.get(response.getCode()));
    }

    public synchronized List<EdgeItem> getEdges(String spaceName) throws TException, ExecuteFailedException {
        ListEdgesResp response;
        int spaceID = this.getSpace(spaceName).getSpace_id();
        ListEdgesReq request = new ListEdgesReq(spaceID);
        try {
            response = this.client.listEdges(request);
        }
        catch (TException e) {
            LOGGER.error(String.format("Get Tag Error: %s", e.getMessage()));
            throw e;
        }
        if (response.getCode() == 0) {
            return response.getEdges();
        }
        LOGGER.error(String.format("Get tags Error: %s", response.getCode()));
        throw new ExecuteFailedException("Get Edges Error:" + ErrorCode.VALUES_TO_NAMES.get(response.getCode()));
    }

    public synchronized Schema getEdge(String spaceName, String edgeName) throws TException, ExecuteFailedException {
        GetEdgeResp response;
        GetEdgeReq request = new GetEdgeReq();
        int spaceID = this.getSpace(spaceName).getSpace_id();
        request.setSpace_id(spaceID);
        request.setEdge_name(edgeName.getBytes());
        request.setVersion(-1L);
        try {
            response = this.client.getEdge(request);
        }
        catch (TException e) {
            LOGGER.error(String.format("Get Tag Error: %s", e.getMessage()));
            throw e;
        }
        if (response.getCode() == 0) {
            return response.getSchema();
        }
        LOGGER.error(String.format("Get Edge execute Error: %s", ErrorCode.VALUES_TO_NAMES.get(response.getCode())));
        throw new ExecuteFailedException("Get Edge execute Error: " + ErrorCode.VALUES_TO_NAMES.get(response.getCode()));
    }

    public synchronized Map<Integer, List<HostAddr>> getPartsAlloc(String spaceName) throws ExecuteFailedException, TException {
        GetPartsAllocResp response;
        GetPartsAllocReq request = new GetPartsAllocReq();
        int spaceID = this.getSpace(spaceName).getSpace_id();
        request.setSpace_id(spaceID);
        try {
            response = this.client.getPartsAlloc(request);
        }
        catch (TException e) {
            LOGGER.error(String.format("Get Parts failed: %s", e.getMessage()));
            throw e;
        }
        if (response.getCode() == 0) {
            return response.getParts();
        }
        LOGGER.error(String.format("Get Parts Error: %s", response.getCode()));
        throw new ExecuteFailedException("Get Parts allocation failed: " + ErrorCode.VALUES_TO_NAMES.get(response.getCode()));
    }

    public synchronized Set<HostAddr> listHosts() {
        ListHostsResp resp;
        ListHostsReq request = new ListHostsReq();
        request.setType(3);
        try {
            resp = this.client.listHosts(request);
        }
        catch (TException e) {
            LOGGER.error("listHosts error", (Throwable)e);
            return null;
        }
        HashSet<HostAddr> hostAddrs = new HashSet<HostAddr>();
        for (HostItem hostItem : resp.hosts) {
            if (hostItem.getStatus() != 0) continue;
            hostAddrs.add(hostItem.getHostAddr());
        }
        return hostAddrs;
    }
}

