/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.data;

import com.vesoft.nebula.Edge;
import com.vesoft.nebula.Path;
import com.vesoft.nebula.Step;
import com.vesoft.nebula.Value;
import com.vesoft.nebula.client.graph.data.Node;
import com.vesoft.nebula.client.graph.data.Relationship;
import com.vesoft.nebula.client.graph.data.ValueWrapper;
import com.vesoft.nebula.client.graph.exception.InvalidValueException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class PathWrapper {
    private List<Segment> segments = new ArrayList<Segment>();
    private List<Node> nodes = new ArrayList<Node>();
    private List<Relationship> relationships = new ArrayList<Relationship>();

    public Node getStartNode() {
        if (this.nodes == null || this.nodes.isEmpty()) {
            return null;
        }
        return this.nodes.get(0);
    }

    public Node getEndNode() {
        if (this.nodes == null || this.nodes.isEmpty()) {
            return null;
        }
        return this.nodes.get(this.nodes.size() - 1);
    }

    public boolean containNode(Node node) {
        return this.nodes.contains(node);
    }

    public boolean containRelationship(Relationship relationship) {
        return this.relationships.contains(relationship);
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<Relationship> getRelationships() {
        return this.relationships;
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public int length() {
        return this.segments.size();
    }

    public PathWrapper(Path path) throws InvalidValueException, UnsupportedEncodingException {
        if (path == null) {
            this.nodes = new ArrayList<Node>();
            this.relationships = new ArrayList<Relationship>();
            this.segments = new ArrayList<Segment>();
            return;
        }
        this.nodes.add(new Node(path.src));
        ArrayList<Value> vids = new ArrayList<Value>();
        vids.add(path.src.vid);
        for (Step step : path.steps) {
            Value dstId;
            Value srcId;
            Node endNode;
            Node startNode;
            int type = step.type;
            if (step.type > 0) {
                startNode = this.nodes.get(this.nodes.size() - 1);
                endNode = new Node(step.dst);
                this.nodes.add(endNode);
                srcId = (Value)vids.get(vids.size() - 1);
                dstId = step.dst.vid;
            } else {
                type = -type;
                startNode = new Node(step.dst);
                endNode = this.nodes.get(this.nodes.size() - 1);
                this.nodes.add(startNode);
                dstId = (Value)vids.get(vids.size() - 1);
                srcId = step.dst.vid;
            }
            vids.add(step.dst.vid);
            Edge edge = new Edge(srcId, dstId, type, step.name, step.ranking, step.props);
            Relationship relationShip = new Relationship(edge);
            this.relationships.add(new Relationship(edge));
            Segment segment = new Segment(startNode, relationShip, endNode);
            if (segment.getStartNode() != this.nodes.get(this.nodes.size() - 1) && segment.getEndNode() != this.nodes.get(this.nodes.size() - 1)) {
                throw new InvalidValueException(String.format("Relationship [%s] does not connect to the last node", relationShip.toString()));
            }
            this.segments.add(segment);
        }
    }

    public String toString() {
        try {
            Node startNode = this.getStartNode();
            ArrayList<String> edgeStrs = new ArrayList<String>();
            if (this.segments.size() >= 1) {
                ArrayList<String> propStrs = new ArrayList<String>();
                HashMap<String, ValueWrapper> props = this.segments.get(0).getRelationShip().properties();
                for (String key : props.keySet()) {
                    propStrs.add(key + ":" + ((ValueWrapper)props.get(key)).toString());
                }
                if (this.segments.get(0).getStartNode() == startNode) {
                    edgeStrs.add(String.format("-[:%s@%d{%s}]->%s", this.segments.get(0).getRelationShip().edgeName(), this.segments.get(0).getRelationShip().ranking(), String.join((CharSequence)", ", propStrs), this.segments.get(0).getEndNode().toString()));
                } else {
                    edgeStrs.add(String.format("<-[:%s@%d{%s}]-%s", this.segments.get(0).getRelationShip().edgeName(), this.segments.get(0).getRelationShip().ranking(), String.join((CharSequence)", ", propStrs), this.segments.get(0).getStartNode().toString()));
                }
            }
            for (int i = 1; i < this.segments.size(); ++i) {
                ArrayList<String> propStrs = new ArrayList<String>();
                HashMap<String, ValueWrapper> props = this.segments.get(0).getRelationShip().properties();
                for (String key : props.keySet()) {
                    propStrs.add(key + ":" + ((ValueWrapper)props.get(key)).toString());
                }
                if (this.segments.get(i).getStartNode() == this.segments.get(i - 1).getStartNode()) {
                    edgeStrs.add(String.format("-[:%s@%d{%s}]->%s", this.segments.get(i).getRelationShip().edgeName(), this.segments.get(i).getRelationShip().ranking(), String.join((CharSequence)", ", propStrs), this.segments.get(i).getEndNode().toString()));
                    continue;
                }
                edgeStrs.add(String.format("<-[:%s@%d{%s}]-%s", this.segments.get(i).getRelationShip().edgeName(), this.segments.get(i).getRelationShip().ranking(), String.join((CharSequence)", ", propStrs), this.segments.get(i).getStartNode().toString()));
            }
            return String.format("%s%s", this.getStartNode().toString(), String.join((CharSequence)"", edgeStrs));
        }
        catch (UnsupportedEncodingException e) {
            return e.getMessage();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathWrapper segments1 = (PathWrapper)o;
        return Objects.equals(this.segments, segments1.segments) && Objects.equals(this.nodes, segments1.nodes) && Objects.equals(this.relationships, segments1.relationships);
    }

    public int hashCode() {
        return Objects.hash(this.segments, this.nodes, this.relationships);
    }

    public static class Segment {
        Node startNode;
        Relationship relationShip;
        Node endNode;

        public Segment(Node startNode, Relationship relationShip, Node endNode) {
            this.startNode = startNode;
            this.relationShip = relationShip;
            this.endNode = endNode;
        }

        public Node getStartNode() {
            return this.startNode;
        }

        public Relationship getRelationShip() {
            return this.relationShip;
        }

        public Node getEndNode() {
            return this.endNode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Segment segment = (Segment)o;
            return Objects.equals(this.startNode, segment.startNode) && Objects.equals(this.relationShip, segment.relationShip) && Objects.equals(this.endNode, segment.endNode);
        }

        public int hashCode() {
            return Objects.hash(this.startNode, this.relationShip, this.endNode);
        }
    }
}

