/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.net;

import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TCompactProtocol;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.transport.TSocket;
import com.facebook.thrift.transport.TTransport;
import com.facebook.thrift.transport.TTransportException;
import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.graph.exception.AuthFailedException;
import com.vesoft.nebula.client.graph.exception.IOErrorException;
import com.vesoft.nebula.client.graph.net.Connection;
import com.vesoft.nebula.graph.AuthResponse;
import com.vesoft.nebula.graph.ExecutionResponse;
import com.vesoft.nebula.graph.GraphService;

public class SyncConnection
extends Connection {
    protected TTransport transport = null;
    protected TProtocol protocol = null;
    private GraphService.Client client = null;

    @Override
    public void open(HostAddress address, int timeout) throws IOErrorException {
        this.serverAddr = address;
        try {
            int newTimeout = timeout <= 0 ? Integer.MAX_VALUE : timeout;
            this.transport = new TSocket(address.getHost(), address.getPort(), newTimeout, newTimeout);
            this.transport.open();
            this.protocol = new TCompactProtocol(this.transport);
            this.client = new GraphService.Client(this.protocol);
        }
        catch (TException e) {
            throw new IOErrorException(0, e.getMessage());
        }
    }

    public long authenticate(String user, String password) throws AuthFailedException, IOErrorException {
        try {
            AuthResponse resp = this.client.authenticate(user.getBytes(), password.getBytes());
            if (resp.error_code != 0) {
                throw new AuthFailedException(new String(resp.error_msg).intern());
            }
            return resp.session_id;
        }
        catch (TException e) {
            TTransportException te;
            if (e instanceof TTransportException && (te = (TTransportException)e).getType() == 4) {
                throw new IOErrorException(2, te.getMessage());
            }
            throw new AuthFailedException(String.format("Authenticate failed: %s", e.getMessage()));
        }
    }

    public ExecutionResponse execute(long sessionID, String stmt) throws IOErrorException {
        try {
            return this.client.execute(sessionID, stmt.getBytes());
        }
        catch (TException e) {
            TTransportException te;
            if (e instanceof TTransportException && (te = (TTransportException)e).getType() == 4) {
                throw new IOErrorException(2, te.getMessage());
            }
            throw new IOErrorException(0, e.getMessage());
        }
    }

    public void signout(long sessionId) {
        try {
            this.client.signout(sessionId);
        }
        catch (TException e) {
            this.close();
        }
    }

    @Override
    public boolean ping() {
        try {
            this.client.execute(0L, "YIELD 1;".getBytes());
            return true;
        }
        catch (TException e) {
            if (e instanceof TTransportException) {
                TTransportException te = (TTransportException)e;
                return te.getType() != 4 && te.getType() != 1;
            }
            return true;
        }
    }

    @Override
    public void close() {
        if (this.transport != null) {
            this.transport.close();
        }
    }
}

