/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.transport;

import com.facebook.thrift.transport.TNonblockingServerTransport;
import com.facebook.thrift.transport.TNonblockingSocket;
import com.facebook.thrift.transport.TTransportException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class TNonblockingServerSocket
extends TNonblockingServerTransport {
    private ServerSocketChannel serverSocketChannel = null;
    private ServerSocket serverSocket_ = null;
    private int port_ = 0;
    private int clientTimeout_ = 0;

    public TNonblockingServerSocket(int port) throws TTransportException {
        this(port, 0);
    }

    public TNonblockingServerSocket(int port, int clientTimeout) throws TTransportException {
        this(port, clientTimeout, 0);
    }

    public TNonblockingServerSocket(int port, int clientTimeout, int backlog) throws TTransportException {
        this.port_ = port;
        this.clientTimeout_ = clientTimeout;
        try {
            this.serverSocketChannel = ServerSocketChannel.open();
            this.serverSocketChannel.configureBlocking(false);
            this.serverSocket_ = this.serverSocketChannel.socket();
            this.serverSocket_.setReuseAddress(true);
            this.serverSocket_.bind(new InetSocketAddress(this.port_), backlog);
        }
        catch (IOException ioe) {
            this.serverSocket_ = null;
            throw new TTransportException("Could not create ServerSocket on port " + port + ".");
        }
    }

    @Override
    public void listen() throws TTransportException {
        if (this.serverSocket_ != null) {
            try {
                this.serverSocket_.setSoTimeout(0);
            }
            catch (SocketException sx) {
                sx.printStackTrace();
            }
        }
    }

    @Override
    protected TNonblockingSocket acceptImpl() throws TTransportException {
        if (this.serverSocket_ == null) {
            throw new TTransportException(1, "No underlying server socket.");
        }
        try {
            SocketChannel socketChannel = this.serverSocketChannel.accept();
            if (socketChannel == null) {
                return null;
            }
            TNonblockingSocket tsocket = new TNonblockingSocket(socketChannel);
            tsocket.setTimeout(this.clientTimeout_);
            return tsocket;
        }
        catch (IOException iox) {
            throw new TTransportException(iox);
        }
    }

    @Override
    public void registerSelector(Selector selector) {
        try {
            this.serverSocketChannel.register(selector, 16);
        }
        catch (ClosedChannelException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        if (this.serverSocket_ != null) {
            try {
                this.serverSocket_.close();
            }
            catch (IOException iox) {
                System.err.println("WARNING: Could not close server socket: " + iox.getMessage());
            }
            this.serverSocket_ = null;
        }
    }

    @Override
    public void interrupt() {
        this.close();
    }

    public int getLocalPort() {
        return this.serverSocket_.getLocalPort();
    }
}

