/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.net;

import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.graph.exception.IOErrorException;
import com.vesoft.nebula.client.graph.net.Connection;
import com.vesoft.nebula.client.graph.net.LoadBalancer;
import com.vesoft.nebula.client.graph.net.SyncConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class RoundRobinLoadBalancer
implements LoadBalancer {
    private static final int S_OK = 0;
    private static final int S_BAD = 1;
    private final List<HostAddress> addresses = new ArrayList<HostAddress>();
    private final Map<HostAddress, Integer> serversStatus = new HashMap<HostAddress, Integer>();
    private final int timeout;
    private final AtomicInteger pos = new AtomicInteger(0);
    private final int delayTime = 60;
    private final ScheduledExecutorService schedule = Executors.newScheduledThreadPool(1);

    public RoundRobinLoadBalancer(List<HostAddress> addresses, int timeout) {
        this.timeout = timeout;
        for (HostAddress addr : addresses) {
            this.addresses.add(addr);
            this.serversStatus.put(addr, 1);
        }
        this.schedule.scheduleAtFixedRate(this::scheduleTask, 0L, 60L, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        this.schedule.shutdownNow();
    }

    @Override
    public HostAddress getAddress() {
        int tryCount = 0;
        while (++tryCount <= this.addresses.size()) {
            int newPos = this.pos.getAndIncrement() % this.addresses.size();
            HostAddress addr = this.addresses.get(newPos);
            if (this.serversStatus.get(addr) != 0) continue;
            return addr;
        }
        return null;
    }

    @Override
    public void updateServersStatus() {
        for (HostAddress addr : this.addresses) {
            if (this.ping(addr)) {
                this.serversStatus.put(addr, 0);
                continue;
            }
            this.serversStatus.put(addr, 1);
        }
    }

    public boolean ping(HostAddress addr) {
        try {
            SyncConnection connection = new SyncConnection();
            ((Connection)connection).open(addr, this.timeout);
            ((Connection)connection).close();
            return true;
        }
        catch (IOErrorException e) {
            return false;
        }
    }

    @Override
    public boolean isServersOK() {
        this.updateServersStatus();
        for (HostAddress addr : this.addresses) {
            if (this.serversStatus.get(addr) != 1) continue;
            return false;
        }
        return true;
    }

    private void scheduleTask() {
        this.updateServersStatus();
    }
}

