/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.data;

import com.google.common.collect.Lists;
import com.vesoft.nebula.Row;
import com.vesoft.nebula.Value;
import com.vesoft.nebula.client.graph.data.ValueWrapper;
import com.vesoft.nebula.graph.ExecutionResponse;
import com.vesoft.nebula.graph.PlanDescription;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;

public class ResultSet {
    private final ExecutionResponse response;
    private List<String> columnNames;
    private final String decodeType = "utf-8";

    public ResultSet(ExecutionResponse resp) {
        if (resp == null) {
            throw new RuntimeException("Input an null `ExecutionResponse' object");
        }
        this.response = resp;
        if (resp.data != null) {
            this.columnNames = Lists.newArrayListWithCapacity(resp.data.column_names.size());
            for (byte[] column : resp.data.column_names) {
                this.columnNames.add(new String(column));
            }
        }
    }

    public boolean isSucceeded() {
        return this.response.error_code == 0;
    }

    public boolean isEmpty() {
        return this.response.data == null || this.response.data.rows.isEmpty();
    }

    public int getErrorCode() {
        return this.response.error_code;
    }

    public String getSpaceName() {
        if (this.response.space_name == null) {
            return "";
        }
        return new String(this.response.space_name);
    }

    public String getErrorMessage() {
        if (this.response.error_msg == null) {
            return "";
        }
        return new String(this.response.error_msg);
    }

    public String getComment() {
        if (this.response.comment == null) {
            return "";
        }
        return new String(this.response.comment);
    }

    public int getLatency() {
        return this.response.latency_in_us;
    }

    public PlanDescription getPlanDesc() {
        return this.response.getPlan_desc();
    }

    public List<String> keys() {
        return this.columnNames;
    }

    public int rowsSize() {
        if (this.response.data == null) {
            return 0;
        }
        return this.response.data.rows.size();
    }

    public Record rowValues(int index) {
        if (this.response.data == null) {
            throw new RuntimeException("Empty data");
        }
        if (index >= this.response.data.rows.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new Record(this.columnNames, this.response.data.rows.get(index));
    }

    public List<ValueWrapper> colValues(String key) {
        if (this.response.data == null) {
            throw new RuntimeException("Empty data");
        }
        int index = this.columnNames.indexOf(key);
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ArrayList<ValueWrapper> values = new ArrayList<ValueWrapper>();
        for (int i = 0; i < this.response.data.rows.size(); ++i) {
            values.add(new ValueWrapper(this.response.data.rows.get((int)i).values.get(index)));
        }
        return values;
    }

    public List<Row> getRows() {
        if (this.response.data == null) {
            throw new RuntimeException("Empty data");
        }
        return this.response.data.rows;
    }

    public static class Record
    implements Iterable<ValueWrapper> {
        private final List<ValueWrapper> colValues = new ArrayList<ValueWrapper>();
        private List<String> columnNames = new ArrayList<String>();

        public Record(List<String> columnNames, Row row) {
            if (columnNames == null) {
                return;
            }
            if (row == null || row.values == null) {
                return;
            }
            for (Value value : row.values) {
                this.colValues.add(new ValueWrapper(value));
            }
            this.columnNames = columnNames;
        }

        @Override
        public Iterator<ValueWrapper> iterator() {
            return this.colValues.iterator();
        }

        @Override
        public void forEach(Consumer<? super ValueWrapper> action) {
            this.colValues.forEach(action);
        }

        @Override
        public Spliterator<ValueWrapper> spliterator() {
            return this.colValues.spliterator();
        }

        public String toString() {
            StringBuilder rowStr = new StringBuilder();
            for (ValueWrapper v : this.colValues) {
                rowStr.append(v.toString()).append(',');
            }
            return "Record{row=" + rowStr + ", columnNames=" + this.columnNames.toString() + '}';
        }

        public ValueWrapper get(int index) {
            if (index >= this.columnNames.size()) {
                throw new IllegalArgumentException(String.format("Cannot get field because the key '%d' out of range", index));
            }
            return this.colValues.get(index);
        }

        public ValueWrapper get(String key) {
            int index = this.columnNames.indexOf(key);
            if (index == -1) {
                throw new IllegalArgumentException("Cannot get field because the key '" + key + "' is not exist");
            }
            return this.colValues.get(index);
        }

        public List<ValueWrapper> values() {
            return this.colValues;
        }

        public int size() {
            return this.columnNames.size();
        }

        public boolean contains(String key) {
            return this.columnNames.contains(key);
        }
    }
}

