/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.data;

import com.vesoft.nebula.Edge;
import com.vesoft.nebula.Value;
import com.vesoft.nebula.client.graph.data.ValueWrapper;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class Relationship {
    private final Edge edge;
    private final String decodeType = "utf-8";

    public Relationship(Edge edge) {
        if (edge == null) {
            throw new RuntimeException("Input an null edge object");
        }
        this.edge = edge;
    }

    public String srcId() throws UnsupportedEncodingException {
        return new String(this.edge.src, "utf-8");
    }

    public String dstId() throws UnsupportedEncodingException {
        return new String(this.edge.dst, "utf-8");
    }

    public String edgeName() throws UnsupportedEncodingException {
        return new String(this.edge.name, "utf-8");
    }

    public long ranking() {
        return this.edge.ranking;
    }

    public List<String> keys() throws UnsupportedEncodingException {
        ArrayList<String> propNames = new ArrayList<String>();
        for (byte[] name : this.edge.props.keySet()) {
            propNames.add(new String(name, "utf-8"));
        }
        return propNames;
    }

    public List<ValueWrapper> values() {
        ArrayList<ValueWrapper> propVals = new ArrayList<ValueWrapper>();
        for (Value val : this.edge.props.values()) {
            propVals.add(new ValueWrapper(val));
        }
        return propVals;
    }

    public HashMap<String, ValueWrapper> properties() throws UnsupportedEncodingException {
        HashMap<String, ValueWrapper> properties = new HashMap<String, ValueWrapper>();
        for (byte[] key : this.edge.props.keySet()) {
            properties.put(new String(key, "utf-8"), new ValueWrapper(this.edge.props.get(key)));
        }
        return properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Relationship that = (Relationship)o;
        try {
            return this.ranking() == that.ranking() && Objects.equals(this.srcId(), that.srcId()) && Objects.equals(this.dstId(), that.dstId()) && Objects.equals(this.edgeName(), that.edgeName());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int hashCode() {
        return Objects.hash(this.edge, "utf-8");
    }

    public String toString() {
        return "Relationship{srcId='" + this.edge.src + ", dstId='" + this.edge.dst + ", edgeName='" + this.edge.name + ", ranking=" + this.edge.ranking + ", propss=" + this.edge.props + '}';
    }
}

