/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.data;

import com.vesoft.nebula.Tag;
import com.vesoft.nebula.Value;
import com.vesoft.nebula.Vertex;
import com.vesoft.nebula.client.graph.data.ValueWrapper;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class Node {
    private Vertex vertex;
    private String vid;
    private String decodeType = "utf-8";
    List<String> tagNames = new ArrayList<String>();

    public Node(Vertex vertex) throws UnsupportedEncodingException {
        if (vertex == null) {
            throw new RuntimeException("Input an null vertex object");
        }
        this.vid = new String(vertex.vid);
        this.vertex = vertex;
        for (Tag tag : vertex.tags) {
            this.tagNames.add(new String(tag.name, this.decodeType));
        }
    }

    public String getId() {
        return this.vid;
    }

    public List<String> labels() {
        return this.tagNames;
    }

    public boolean hasLabel(String tagName) {
        return this.tagNames.contains(tagName);
    }

    public List<ValueWrapper> values(String tagName) {
        int index = this.tagNames.indexOf(tagName);
        if (index < 0) {
            throw new IllegalArgumentException(tagName + " is not found");
        }
        ArrayList<ValueWrapper> values = new ArrayList<ValueWrapper>();
        for (Value val : this.vertex.tags.get((int)index).props.values()) {
            values.add(new ValueWrapper(val));
        }
        return values;
    }

    public List<String> keys(String tagName) throws UnsupportedEncodingException {
        int index = this.tagNames.indexOf(tagName);
        if (index < 0) {
            throw new IllegalArgumentException(tagName + " is not found");
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (byte[] name : this.vertex.tags.get((int)index).props.keySet()) {
            keys.add(new String(name, this.decodeType));
        }
        return keys;
    }

    public HashMap<String, ValueWrapper> properties(String tagName) throws UnsupportedEncodingException {
        int index = this.tagNames.indexOf(tagName);
        if (index < 0) {
            throw new IllegalArgumentException(tagName + " is not found");
        }
        HashMap<String, ValueWrapper> properties = new HashMap<String, ValueWrapper>();
        for (byte[] name : this.vertex.tags.get((int)index).props.keySet()) {
            properties.put(new String(name, this.decodeType), new ValueWrapper(this.vertex.tags.get((int)index).props.get(name)));
        }
        return properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return Objects.equals(this.vid, node.vid);
    }

    public int hashCode() {
        return Objects.hash(this.vertex, this.vid, this.decodeType, this.tagNames);
    }

    public String toString() {
        return "Node{vertex=" + this.vertex + ", decodeType='" + this.decodeType + '}';
    }
}

