/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Vertex
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("Vertex");
    private static final TField VID_FIELD_DESC = new TField("vid", 11, 1);
    private static final TField TAGS_FIELD_DESC = new TField("tags", 15, 2);
    public byte[] vid;
    public List<Tag> tags;
    public static final int VID = 1;
    public static final int TAGS = 2;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public Vertex() {
    }

    public Vertex(byte[] vid, List<Tag> tags) {
        this();
        this.vid = vid;
        this.tags = tags;
    }

    public Vertex(Vertex other) {
        if (other.isSetVid()) {
            this.vid = TBaseHelper.deepCopy(other.vid);
        }
        if (other.isSetTags()) {
            this.tags = TBaseHelper.deepCopy(other.tags);
        }
    }

    @Override
    public Vertex deepCopy() {
        return new Vertex(this);
    }

    @Deprecated
    public Vertex clone() {
        return new Vertex(this);
    }

    public byte[] getVid() {
        return this.vid;
    }

    public Vertex setVid(byte[] vid) {
        this.vid = vid;
        return this;
    }

    public void unsetVid() {
        this.vid = null;
    }

    public boolean isSetVid() {
        return this.vid != null;
    }

    public void setVidIsSet(boolean value) {
        if (!value) {
            this.vid = null;
        }
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public Vertex setTags(List<Tag> tags) {
        this.tags = tags;
        return this;
    }

    public void unsetTags() {
        this.tags = null;
    }

    public boolean isSetTags() {
        return this.tags != null;
    }

    public void setTagsIsSet(boolean value) {
        if (!value) {
            this.tags = null;
        }
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetVid();
                    break;
                }
                this.setVid((byte[])value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetTags();
                    break;
                }
                this.setTags((List)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getVid();
            }
            case 2: {
                return this.getTags();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetVid();
            }
            case 2: {
                return this.isSetTags();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Vertex) {
            return this.equals((Vertex)that);
        }
        return false;
    }

    public boolean equals(Vertex that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_vid = this.isSetVid();
        boolean that_present_vid = that.isSetVid();
        if (this_present_vid || that_present_vid) {
            if (!this_present_vid || !that_present_vid) {
                return false;
            }
            if (!TBaseHelper.equalsSlow(this.vid, that.vid)) {
                return false;
            }
        }
        boolean this_present_tags = this.isSetTags();
        boolean that_present_tags = that.isSetTags();
        if (this_present_tags || that_present_tags) {
            if (!this_present_tags || !that_present_tags) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.tags, that.tags)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_vid = this.isSetVid();
        builder.append(present_vid);
        if (present_vid) {
            builder.append(this.vid);
        }
        boolean present_tags = this.isSetTags();
        builder.append(present_tags);
        if (present_tags) {
            builder.append(this.tags);
        }
        return builder.toHashCode();
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 11) {
                        this.vid = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 15) {
                        TList _list30 = iprot.readListBegin();
                        this.tags = new ArrayList<Tag>(Math.max(0, _list30.size));
                        int _i31 = 0;
                        while (_list30.size < 0 ? iprot.peekList() : _i31 < _list30.size) {
                            Tag _elem32 = new Tag();
                            _elem32.read(iprot);
                            this.tags.add(_elem32);
                            ++_i31;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.vid != null) {
            oprot.writeFieldBegin(VID_FIELD_DESC);
            oprot.writeBinary(this.vid);
            oprot.writeFieldEnd();
        }
        if (this.tags != null) {
            oprot.writeFieldBegin(TAGS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.tags.size()));
            for (Tag _iter33 : this.tags) {
                _iter33.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("Vertex");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("vid");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getVid() == null) {
            sb.append("null");
        } else {
            int __vid_size = Math.min(this.getVid().length, 128);
            for (int i = 0; i < __vid_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getVid()[i]).length() > 1 ? Integer.toHexString(this.getVid()[i]).substring(Integer.toHexString(this.getVid()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getVid()[i]).toUpperCase());
            }
            if (this.getVid().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("tags");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getTags() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getTags(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("vid", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(2, new FieldMetaData("tags", 3, new ListMetaData(15, new StructMetaData(12, Tag.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(Vertex.class, metaDataMap);
    }
}

