/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.MapMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolException;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.Schema;
import com.vesoft.nebula.storage.ResponseCommon;
import com.vesoft.nebula.storage.VertexData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class QueryResponse
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("QueryResponse");
    private static final TField RESULT_FIELD_DESC = new TField("result", 12, 1);
    private static final TField VERTEX_SCHEMA_FIELD_DESC = new TField("vertex_schema", 13, 2);
    private static final TField EDGE_SCHEMA_FIELD_DESC = new TField("edge_schema", 13, 3);
    private static final TField VERTICES_FIELD_DESC = new TField("vertices", 15, 4);
    private static final TField TOTAL_EDGES_FIELD_DESC = new TField("total_edges", 8, 5);
    public ResponseCommon result;
    public Map<Integer, Schema> vertex_schema;
    public Map<Integer, Schema> edge_schema;
    public List<VertexData> vertices;
    public int total_edges;
    public static final int RESULT = 1;
    public static final int VERTEX_SCHEMA = 2;
    public static final int EDGE_SCHEMA = 3;
    public static final int VERTICES = 4;
    public static final int TOTAL_EDGES = 5;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    private static final int __TOTAL_EDGES_ISSET_ID = 0;
    private BitSet __isset_bit_vector = new BitSet(1);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public QueryResponse() {
    }

    public QueryResponse(ResponseCommon result) {
        this();
        this.result = result;
    }

    public QueryResponse(ResponseCommon result, Map<Integer, Schema> vertex_schema, Map<Integer, Schema> edge_schema, List<VertexData> vertices, int total_edges) {
        this();
        this.result = result;
        this.vertex_schema = vertex_schema;
        this.edge_schema = edge_schema;
        this.vertices = vertices;
        this.total_edges = total_edges;
        this.setTotal_edgesIsSet(true);
    }

    public QueryResponse(QueryResponse other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        if (other.isSetResult()) {
            this.result = TBaseHelper.deepCopy(other.result);
        }
        if (other.isSetVertex_schema()) {
            this.vertex_schema = TBaseHelper.deepCopy(other.vertex_schema);
        }
        if (other.isSetEdge_schema()) {
            this.edge_schema = TBaseHelper.deepCopy(other.edge_schema);
        }
        if (other.isSetVertices()) {
            this.vertices = TBaseHelper.deepCopy(other.vertices);
        }
        this.total_edges = TBaseHelper.deepCopy(other.total_edges);
    }

    @Override
    public QueryResponse deepCopy() {
        return new QueryResponse(this);
    }

    @Deprecated
    public QueryResponse clone() {
        return new QueryResponse(this);
    }

    public ResponseCommon getResult() {
        return this.result;
    }

    public QueryResponse setResult(ResponseCommon result) {
        this.result = result;
        return this;
    }

    public void unsetResult() {
        this.result = null;
    }

    public boolean isSetResult() {
        return this.result != null;
    }

    public void setResultIsSet(boolean value) {
        if (!value) {
            this.result = null;
        }
    }

    public Map<Integer, Schema> getVertex_schema() {
        return this.vertex_schema;
    }

    public QueryResponse setVertex_schema(Map<Integer, Schema> vertex_schema) {
        this.vertex_schema = vertex_schema;
        return this;
    }

    public void unsetVertex_schema() {
        this.vertex_schema = null;
    }

    public boolean isSetVertex_schema() {
        return this.vertex_schema != null;
    }

    public void setVertex_schemaIsSet(boolean value) {
        if (!value) {
            this.vertex_schema = null;
        }
    }

    public Map<Integer, Schema> getEdge_schema() {
        return this.edge_schema;
    }

    public QueryResponse setEdge_schema(Map<Integer, Schema> edge_schema) {
        this.edge_schema = edge_schema;
        return this;
    }

    public void unsetEdge_schema() {
        this.edge_schema = null;
    }

    public boolean isSetEdge_schema() {
        return this.edge_schema != null;
    }

    public void setEdge_schemaIsSet(boolean value) {
        if (!value) {
            this.edge_schema = null;
        }
    }

    public List<VertexData> getVertices() {
        return this.vertices;
    }

    public QueryResponse setVertices(List<VertexData> vertices) {
        this.vertices = vertices;
        return this;
    }

    public void unsetVertices() {
        this.vertices = null;
    }

    public boolean isSetVertices() {
        return this.vertices != null;
    }

    public void setVerticesIsSet(boolean value) {
        if (!value) {
            this.vertices = null;
        }
    }

    public int getTotal_edges() {
        return this.total_edges;
    }

    public QueryResponse setTotal_edges(int total_edges) {
        this.total_edges = total_edges;
        this.setTotal_edgesIsSet(true);
        return this;
    }

    public void unsetTotal_edges() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetTotal_edges() {
        return this.__isset_bit_vector.get(0);
    }

    public void setTotal_edgesIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetResult();
                    break;
                }
                this.setResult((ResponseCommon)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetVertex_schema();
                    break;
                }
                this.setVertex_schema((Map)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetEdge_schema();
                    break;
                }
                this.setEdge_schema((Map)value);
                break;
            }
            case 4: {
                if (value == null) {
                    this.unsetVertices();
                    break;
                }
                this.setVertices((List)value);
                break;
            }
            case 5: {
                if (value == null) {
                    this.unsetTotal_edges();
                    break;
                }
                this.setTotal_edges((Integer)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getResult();
            }
            case 2: {
                return this.getVertex_schema();
            }
            case 3: {
                return this.getEdge_schema();
            }
            case 4: {
                return this.getVertices();
            }
            case 5: {
                return new Integer(this.getTotal_edges());
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetResult();
            }
            case 2: {
                return this.isSetVertex_schema();
            }
            case 3: {
                return this.isSetEdge_schema();
            }
            case 4: {
                return this.isSetVertices();
            }
            case 5: {
                return this.isSetTotal_edges();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof QueryResponse) {
            return this.equals((QueryResponse)that);
        }
        return false;
    }

    public boolean equals(QueryResponse that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_result = this.isSetResult();
        boolean that_present_result = that.isSetResult();
        if (this_present_result || that_present_result) {
            if (!this_present_result || !that_present_result) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.result, that.result)) {
                return false;
            }
        }
        boolean this_present_vertex_schema = this.isSetVertex_schema();
        boolean that_present_vertex_schema = that.isSetVertex_schema();
        if (this_present_vertex_schema || that_present_vertex_schema) {
            if (!this_present_vertex_schema || !that_present_vertex_schema) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.vertex_schema, that.vertex_schema)) {
                return false;
            }
        }
        boolean this_present_edge_schema = this.isSetEdge_schema();
        boolean that_present_edge_schema = that.isSetEdge_schema();
        if (this_present_edge_schema || that_present_edge_schema) {
            if (!this_present_edge_schema || !that_present_edge_schema) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.edge_schema, that.edge_schema)) {
                return false;
            }
        }
        boolean this_present_vertices = this.isSetVertices();
        boolean that_present_vertices = that.isSetVertices();
        if (this_present_vertices || that_present_vertices) {
            if (!this_present_vertices || !that_present_vertices) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.vertices, that.vertices)) {
                return false;
            }
        }
        boolean this_present_total_edges = this.isSetTotal_edges();
        boolean that_present_total_edges = that.isSetTotal_edges();
        if (this_present_total_edges || that_present_total_edges) {
            if (!this_present_total_edges || !that_present_total_edges) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.total_edges, that.total_edges)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_result = this.isSetResult();
        builder.append(present_result);
        if (present_result) {
            builder.append(this.result);
        }
        boolean present_vertex_schema = this.isSetVertex_schema();
        builder.append(present_vertex_schema);
        if (present_vertex_schema) {
            builder.append(this.vertex_schema);
        }
        boolean present_edge_schema = this.isSetEdge_schema();
        builder.append(present_edge_schema);
        if (present_edge_schema) {
            builder.append(this.edge_schema);
        }
        boolean present_vertices = this.isSetVertices();
        builder.append(present_vertices);
        if (present_vertices) {
            builder.append(this.vertices);
        }
        boolean present_total_edges = this.isSetTotal_edges();
        builder.append(present_total_edges);
        if (present_total_edges) {
            builder.append(this.total_edges);
        }
        return builder.toHashCode();
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 12) {
                        this.result = new ResponseCommon();
                        this.result.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 13) {
                        TMap _map16 = iprot.readMapBegin();
                        this.vertex_schema = new HashMap<Integer, Schema>(Math.max(0, 2 * _map16.size));
                        int _i17 = 0;
                        while (_map16.size < 0 ? iprot.peekMap() : _i17 < _map16.size) {
                            int _key18 = iprot.readI32();
                            Schema _val19 = new Schema();
                            _val19.read(iprot);
                            this.vertex_schema.put(_key18, _val19);
                            ++_i17;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 13) {
                        TMap _map20 = iprot.readMapBegin();
                        this.edge_schema = new HashMap<Integer, Schema>(Math.max(0, 2 * _map20.size));
                        int _i21 = 0;
                        while (_map20.size < 0 ? iprot.peekMap() : _i21 < _map20.size) {
                            int _key22 = iprot.readI32();
                            Schema _val23 = new Schema();
                            _val23.read(iprot);
                            this.edge_schema.put(_key22, _val23);
                            ++_i21;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 4: {
                    if (field.type == 15) {
                        TList _list24 = iprot.readListBegin();
                        this.vertices = new ArrayList<VertexData>(Math.max(0, _list24.size));
                        int _i25 = 0;
                        while (_list24.size < 0 ? iprot.peekList() : _i25 < _list24.size) {
                            VertexData _elem26 = new VertexData();
                            _elem26.read(iprot);
                            this.vertices.add(_elem26);
                            ++_i25;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 5: {
                    if (field.type == 8) {
                        this.total_edges = iprot.readI32();
                        this.setTotal_edgesIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.result != null) {
            oprot.writeFieldBegin(RESULT_FIELD_DESC);
            this.result.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.vertex_schema != null && this.isSetVertex_schema()) {
            oprot.writeFieldBegin(VERTEX_SCHEMA_FIELD_DESC);
            oprot.writeMapBegin(new TMap(8, 12, this.vertex_schema.size()));
            for (Map.Entry<Integer, Schema> entry : this.vertex_schema.entrySet()) {
                oprot.writeI32(entry.getKey());
                entry.getValue().write(oprot);
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        if (this.edge_schema != null && this.isSetEdge_schema()) {
            oprot.writeFieldBegin(EDGE_SCHEMA_FIELD_DESC);
            oprot.writeMapBegin(new TMap(8, 12, this.edge_schema.size()));
            for (Map.Entry entry : this.edge_schema.entrySet()) {
                oprot.writeI32((Integer)entry.getKey());
                ((Schema)entry.getValue()).write(oprot);
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        if (this.vertices != null && this.isSetVertices()) {
            oprot.writeFieldBegin(VERTICES_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.vertices.size()));
            for (VertexData vertexData : this.vertices) {
                vertexData.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.isSetTotal_edges()) {
            oprot.writeFieldBegin(TOTAL_EDGES_FIELD_DESC);
            oprot.writeI32(this.total_edges);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("QueryResponse");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("result");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getResult() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getResult(), indent + 1, prettyPrint));
        }
        first = false;
        if (this.isSetVertex_schema()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("vertex_schema");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getVertex_schema() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getVertex_schema(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (this.isSetEdge_schema()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("edge_schema");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getEdge_schema() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getEdge_schema(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (this.isSetVertices()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("vertices");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getVertices() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getVertices(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (this.isSetTotal_edges()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("total_edges");
            sb.append(space);
            sb.append(":").append(space);
            sb.append(TBaseHelper.toString(this.getTotal_edges(), indent + 1, prettyPrint));
            first = false;
        }
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.result == null) {
            throw new TProtocolException(6, "Required field 'result' was not present! Struct: " + this.toString());
        }
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("result", 1, new StructMetaData(12, ResponseCommon.class)));
        tmpMetaDataMap.put(2, new FieldMetaData("vertex_schema", 2, new MapMetaData(13, new FieldValueMetaData(8), new StructMetaData(12, Schema.class))));
        tmpMetaDataMap.put(3, new FieldMetaData("edge_schema", 2, new MapMetaData(13, new FieldValueMetaData(8), new StructMetaData(12, Schema.class))));
        tmpMetaDataMap.put(4, new FieldMetaData("vertices", 2, new ListMetaData(15, new StructMetaData(12, VertexData.class))));
        tmpMetaDataMap.put(5, new FieldMetaData("total_edges", 2, new FieldValueMetaData(8)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(QueryResponse.class, metaDataMap);
    }
}

