/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.vesoft.nebula.ColumnDef;
import com.vesoft.nebula.NebulaCodec;
import com.vesoft.nebula.Schema;
import com.vesoft.nebula.data.Property;
import com.vesoft.nebula.data.PropertyDef;
import com.vesoft.nebula.data.Row;
import com.vesoft.nebula.utils.NativeUtils;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(RowReader.class);
    private long schemaVersion;
    private Map<String, Integer> propertyNameIndex = Maps.newHashMap();
    private List<NebulaCodec.Pair> defs = Lists.newLinkedList();
    private List<PropertyDef.PropertyType> types = Lists.newLinkedList();

    public RowReader(Schema schema) {
        this(schema, 0L);
    }

    public RowReader(Schema schema, long schemaVersion) {
        this.schemaVersion = schemaVersion;
        int idx = 0;
        for (ColumnDef columnDef : schema.columns) {
            PropertyDef.PropertyType type = PropertyDef.PropertyType.getEnum(columnDef.getType().getType());
            String name = columnDef.getName();
            switch (type) {
                case BOOL: {
                    this.defs.add(new NebulaCodec.Pair(name, Boolean.class.getName()));
                    break;
                }
                case INT: 
                case VID: {
                    this.defs.add(new NebulaCodec.Pair(name, Long.class.getName()));
                    break;
                }
                case FLOAT: {
                    this.defs.add(new NebulaCodec.Pair(name, Float.class.getName()));
                    break;
                }
                case DOUBLE: {
                    this.defs.add(new NebulaCodec.Pair(name, Double.class.getName()));
                    break;
                }
                case STRING: {
                    this.defs.add(new NebulaCodec.Pair(name, byte[].class.getName()));
                    break;
                }
                case TIMESTAMP: {
                    this.defs.add(new NebulaCodec.Pair(name, Long.class.getName()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid type in schema: " + (Object)((Object)type));
                }
            }
            this.types.add(type);
            this.propertyNameIndex.put(name, idx);
            ++idx;
        }
    }

    public Property[] decodeValue(byte[] value) {
        return this.decodeValue(value, this.schemaVersion);
    }

    public Property[] decodeValue(byte[] value, long schemaVersion) {
        List<byte[]> decodedResult = NebulaCodec.decode(value, this.defs.toArray(new NebulaCodec.Pair[this.defs.size()]), schemaVersion);
        Property[] properties = new Property[this.defs.size()];
        try {
            block9: for (int i = 0; i < this.defs.size(); ++i) {
                String field = this.defs.get(i).getField();
                PropertyDef.PropertyType type = this.types.get(i);
                byte[] data = decodedResult.get(i);
                switch (this.types.get(i)) {
                    case BOOL: {
                        properties[i] = this.getBoolProperty(field, data);
                        continue block9;
                    }
                    case INT: 
                    case VID: {
                        properties[i] = this.getIntProperty(field, data);
                        continue block9;
                    }
                    case FLOAT: {
                        properties[i] = this.getFloatProperty(field, data);
                        continue block9;
                    }
                    case DOUBLE: {
                        properties[i] = this.getDoubleProperty(field, data);
                        continue block9;
                    }
                    case STRING: {
                        properties[i] = this.getStringProperty(field, data);
                        continue block9;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid type in schema: " + (Object)((Object)type));
                    }
                }
            }
        }
        catch (BufferUnderflowException e) {
            LOGGER.error("Decode value failed: " + e.getMessage());
        }
        return properties;
    }

    public Property[] vertexKey(long vertexId, int tagId) {
        Property[] properties = new Property[]{new Property(PropertyDef.PropertyType.VERTEX_ID, "_vertexId", vertexId), new Property(PropertyDef.PropertyType.TAG_ID, "_tagId", tagId)};
        return properties;
    }

    public Property[] edgeKey(long srcId, int edgeType, long dstId) {
        Property[] properties = new Property[]{new Property(PropertyDef.PropertyType.SRC_ID, "_srcId", srcId), new Property(PropertyDef.PropertyType.EDGE_TYPE, "_edgeType", edgeType), new Property(PropertyDef.PropertyType.DST_ID, "_dstId", dstId)};
        return properties;
    }

    public Property[] decodeVertexKey(byte[] key) {
        Property[] properties = new Property[2];
        ByteBuffer buffer = ByteBuffer.wrap(key);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        try {
            buffer.getInt();
            long vertexId = buffer.getLong();
            int tagId = buffer.getInt();
            properties[0] = new Property(PropertyDef.PropertyType.VERTEX_ID, "_vertexId", vertexId);
            properties[1] = new Property(PropertyDef.PropertyType.TAG_ID, "_tagId", tagId);
            return properties;
        }
        catch (BufferUnderflowException e) {
            LOGGER.error("Decode key failed: " + e.getMessage());
            return null;
        }
    }

    public Property[] decodeEdgeKey(byte[] key) {
        ByteBuffer buffer = ByteBuffer.wrap(key);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        try {
            Property[] properties = new Property[]{new Property(PropertyDef.PropertyType.SRC_ID, "_srcId", buffer.getLong()), new Property(PropertyDef.PropertyType.EDGE_TYPE, "_edgeType", buffer.getInt()), new Property(PropertyDef.PropertyType.EDGE_RANK, "_rank", buffer.getLong()), new Property(PropertyDef.PropertyType.DST_ID, "_dstId", buffer.getLong())};
            return properties;
        }
        catch (BufferUnderflowException e) {
            LOGGER.error("Decode key failed: " + e.getMessage());
            return null;
        }
    }

    public Property getProperty(Row row, String name) {
        if (!this.propertyNameIndex.containsKey(name)) {
            return null;
        }
        return row.getProperties()[this.propertyNameIndex.get(name)];
    }

    public Property getProperty(Row row, int index) {
        if (index < 0 || index >= row.getProperties().length) {
            return null;
        }
        return row.getProperties()[index];
    }

    private Property getBoolProperty(String name, byte[] data) {
        boolean value = data[0] != 0;
        return new Property(PropertyDef.PropertyType.BOOL, name, value);
    }

    private Property getIntProperty(String name, byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return new Property(PropertyDef.PropertyType.INT, name, buffer.getLong());
    }

    private Property getFloatProperty(String name, byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return new Property(PropertyDef.PropertyType.FLOAT, name, Float.valueOf(buffer.getFloat()));
    }

    private Property getDoubleProperty(String name, byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return new Property(PropertyDef.PropertyType.DOUBLE, name, buffer.getDouble());
    }

    private Property getStringProperty(String name, byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        return new Property(PropertyDef.PropertyType.STRING, name, new String(buffer.array()));
    }

    static {
        try {
            NativeUtils.loadLibraryFromJar("/libnebula_codec.so", NebulaCodec.class);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
        }
    }
}

