/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AddressUtil {
    public static String intToIPv4(int ip) {
        StringBuilder sb = new StringBuilder();
        int num = 0;
        boolean needPoint = false;
        for (int i = 0; i < 4; ++i) {
            if (needPoint) {
                sb.append('.');
            }
            needPoint = true;
            int offset = 8 * (3 - i);
            num = ip >> offset & 0xFF;
            sb.append(num);
        }
        return sb.toString();
    }

    public static int ip2Integer(String address) {
        if (!AddressUtil.isIPv4Address(address)) {
            throw new RuntimeException("Invalid ip address");
        }
        Pattern pattern = Pattern.compile("\\d+");
        Matcher matcher = pattern.matcher(address);
        int result = 0;
        int counter = 0;
        while (matcher.find()) {
            int value = Integer.parseInt(matcher.group());
            result = value << 8 * (3 - counter++) | result;
        }
        return result;
    }

    private static boolean isIPv4Address(String address) {
        String lower = "(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])";
        String regex = lower + "(\\." + lower + "){3}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(address);
        return matcher.matches();
    }
}

