/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.entry;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TException;
import com.facebook.thrift.async.AsyncMethodCallback;
import com.facebook.thrift.async.TAsyncMethodCall;
import com.google.common.base.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNebulaCallback
implements AsyncMethodCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNebulaCallback.class);
    protected TBase result;
    protected AtomicBoolean isReady = new AtomicBoolean(false);

    public Optional<?> getResult() throws InterruptedException {
        while (!this.checkReady()) {
            Thread.sleep(100L);
        }
        return Optional.of((Object)this.result);
    }

    @Override
    public void onComplete(TAsyncMethodCall response) {
        try {
            this.doComplete(response);
            this.isReady.compareAndSet(false, true);
        }
        catch (TException e) {
            e.printStackTrace();
        }
    }

    public abstract void doComplete(TAsyncMethodCall var1) throws TException;

    public boolean checkReady() {
        return this.isReady.get();
    }

    @Override
    public void onError(Exception exception) {
        LOGGER.error(String.format("onError: %s", exception.toString()));
        exception.printStackTrace();
    }
}

