/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.data;

import com.vesoft.nebula.data.Row;
import java.util.List;
import java.util.Map;

public class Result<ReqT> {
    private Map<RowDesc, List<Row>> rows;
    private int size = 0;

    public Result(Map<RowDesc, List<Row>> rows) {
        this.rows = rows;
        for (Map.Entry<RowDesc, List<Row>> entry : rows.entrySet()) {
            this.size += entry.getValue().size();
        }
    }

    public Map<RowDesc, List<Row>> getRows() {
        return this.rows;
    }

    public List<Row> getRows(RowDesc desc) {
        return this.rows.get(desc);
    }

    public int getSize() {
        return this.size;
    }

    public static class RowDesc {
        private RowType type;
        private String name;

        public RowDesc(RowType type, String name) {
            this.type = type;
            this.name = name;
        }

        public RowType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum RowType {
        VERTEX,
        EDGE;

    }
}

