/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph;

import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TCompactProtocol;
import com.facebook.thrift.transport.TSocket;
import com.google.common.net.HostAndPort;
import com.vesoft.nebula.AbstractClient;
import com.vesoft.nebula.client.graph.ConnectionException;
import com.vesoft.nebula.client.graph.GraphClient;
import com.vesoft.nebula.client.graph.NGQLException;
import com.vesoft.nebula.client.graph.ResultSet;
import com.vesoft.nebula.graph.AuthResponse;
import com.vesoft.nebula.graph.ExecutionResponse;
import com.vesoft.nebula.graph.GraphService;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphClientImpl
extends AbstractClient
implements GraphClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphClientImpl.class);
    protected String user;
    protected String password;
    private long sessionID;
    private GraphService.Client client;

    public GraphClientImpl(List<HostAndPort> addresses, int timeout, int connectionRetry, int executionRetry) {
        super(addresses, timeout, connectionRetry, executionRetry);
    }

    public GraphClientImpl(List<HostAndPort> addresses) {
        super(addresses);
    }

    public GraphClientImpl(String host, int port) {
        super(host, port);
    }

    @Override
    public int doConnect(List<HostAndPort> addresses) throws TException {
        Random random = new Random(System.currentTimeMillis());
        int position = random.nextInt(addresses.size());
        HostAndPort address = addresses.get(position);
        this.transport = new TSocket(address.getHostText(), address.getPort(), this.timeout);
        this.transport.open();
        this.protocol = new TCompactProtocol(this.transport);
        this.client = new GraphService.Client(this.protocol);
        AuthResponse result = this.client.authenticate(this.user, this.password);
        if (result.getError_code() == -4) {
            LOGGER.error("User name or password error");
            return -4;
        }
        if (result.getError_code() != 0) {
            LOGGER.error(String.format("Connect address %s failed : %s", address.toString(), result.getError_msg()));
        } else {
            this.sessionID = result.getSession_id();
        }
        return 0;
    }

    @Override
    public int switchSpace(String space) {
        return this.execute(String.format("USE %s", space));
    }

    @Override
    public int execute(String statement) {
        if (!this.checkTransportOpened(this.transport)) {
            return -1;
        }
        int retry = this.executionRetry;
        if (retry-- > 0) {
            try {
                ExecutionResponse executionResponse = this.client.execute(this.sessionID, statement);
                if (executionResponse.getError_code() != 0) {
                    LOGGER.error("execute error: " + executionResponse.getError_msg());
                }
                return executionResponse.getError_code();
            }
            catch (TException e) {
                LOGGER.error("Thrift rpc call failed: " + e.getMessage());
                return -3;
            }
        }
        return -3;
    }

    @Override
    public ResultSet executeQuery(String statement) throws ConnectionException, NGQLException, TException {
        if (!this.checkTransportOpened(this.transport)) {
            LOGGER.error("Thrift rpc call failed");
            throw new ConnectionException();
        }
        ExecutionResponse executionResponse = this.client.execute(this.sessionID, statement);
        int code = executionResponse.getError_code();
        if (code == 0) {
            return new ResultSet(executionResponse.getColumn_names(), executionResponse.getRows());
        }
        LOGGER.error("Execute error: " + executionResponse.getError_msg());
        throw new NGQLException(code);
    }

    @Override
    public void close() {
        super.close();
        try {
            this.client.signout(this.sessionID);
        }
        catch (TException e) {
            LOGGER.error("Disconnect error: " + e.getMessage());
        }
        finally {
            this.transport.close();
        }
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }
}

