/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.graph;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.graph.ColumnValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class RowValue
implements TBase,
Serializable,
Cloneable,
Comparable<RowValue> {
    private static final TStruct STRUCT_DESC = new TStruct("RowValue");
    private static final TField COLUMNS_FIELD_DESC = new TField("columns", 15, 1);
    public List<ColumnValue> columns;
    public static final int COLUMNS = 1;
    public static boolean DEFAULT_PRETTY_PRINT = true;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public RowValue() {
    }

    public RowValue(List<ColumnValue> columns) {
        this();
        this.columns = columns;
    }

    public RowValue(RowValue other) {
        if (other.isSetColumns()) {
            this.columns = TBaseHelper.deepCopy(other.columns);
        }
    }

    @Override
    public RowValue deepCopy() {
        return new RowValue(this);
    }

    @Deprecated
    public RowValue clone() {
        return new RowValue(this);
    }

    public List<ColumnValue> getColumns() {
        return this.columns;
    }

    public RowValue setColumns(List<ColumnValue> columns) {
        this.columns = columns;
        return this;
    }

    public void unsetColumns() {
        this.columns = null;
    }

    public boolean isSetColumns() {
        return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
        if (!value) {
            this.columns = null;
        }
    }

    @Override
    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetColumns();
                    break;
                }
                this.setColumns((List)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    @Override
    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getColumns();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    @Override
    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetColumns();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof RowValue) {
            return this.equals((RowValue)that);
        }
        return false;
    }

    public boolean equals(RowValue that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_columns = this.isSetColumns();
        boolean that_present_columns = that.isSetColumns();
        if (this_present_columns || that_present_columns) {
            if (!this_present_columns || !that_present_columns) {
                return false;
            }
            if (!TBaseHelper.equalsNobinary(this.columns, that.columns)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_columns = this.isSetColumns();
        builder.append(present_columns);
        if (present_columns) {
            builder.append(this.columns);
        }
        return builder.toHashCode();
    }

    @Override
    public int compareTo(RowValue other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetColumns()).compareTo(other.isSetColumns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.columns, other.columns);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 15) {
                        TList _list0 = iprot.readListBegin();
                        this.columns = new ArrayList<ColumnValue>(Math.max(0, _list0.size));
                        int _i1 = 0;
                        while (_list0.size < 0 ? iprot.peekList() : _i1 < _list0.size) {
                            ColumnValue _elem2 = new ColumnValue();
                            _elem2.read(iprot);
                            this.columns.add(_elem2);
                            ++_i1;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.columns != null) {
            oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.columns.size()));
            for (ColumnValue _iter3 : this.columns) {
                _iter3.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(DEFAULT_PRETTY_PRINT);
    }

    @Override
    public String toString(boolean prettyPrint) {
        return this.toString(1, prettyPrint);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("RowValue");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("columns");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getColumns() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getColumns(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("columns", 3, new ListMetaData(15, new StructMetaData(12, ColumnValue.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(RowValue.class, metaDataMap);
    }
}

