/*
 * Decompiled with CFR 0.152.
 */
package com.versioneye;

import com.versioneye.utils.PropertiesUtils;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

public class SuperMojo
extends AbstractMojo {
    protected static final String propertiesFile = "versioneye.properties";
    @Component
    protected RepositorySystem system;
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}")
    protected RepositorySystemSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}")
    protected List<RemoteRepository> repos;
    @Parameter(defaultValue="${basedir}", property="basedir", required=true)
    protected File projectDirectory;
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    protected File outputDirectory;
    @Parameter(defaultValue="${user.home}")
    protected File homeDirectory;
    @Parameter(property="baseUrl", defaultValue="https://www.versioneye.com")
    protected String baseUrl;
    @Parameter(property="apiPath", defaultValue="/api/v2")
    protected String apiPath;
    @Parameter(property="projectId")
    protected String projectId;
    @Parameter(property="apiKey")
    protected String apiKey;
    @Parameter(property="propertiesPath")
    protected String propertiesPath = null;
    @Parameter(property="proxyHost")
    protected String proxyHost = null;
    @Parameter(property="proxyPort")
    protected String proxyPort = null;
    @Parameter(property="proxyUser")
    protected String proxyUser = null;
    @Parameter(property="proxyPassword")
    protected String proxyPassword = null;
    @Parameter(property="updatePropertiesAfterCreate")
    protected boolean updatePropertiesAfterCreate = true;
    @Parameter(property="mergeAfterCreate")
    protected boolean mergeAfterCreate = true;
    @Parameter(property="parentGroupId")
    protected String parentGroupId = null;
    @Parameter(property="parentArtifactId")
    protected String parentArtifactId = null;
    @Parameter(property="nameStrategy")
    protected String nameStrategy = "name";
    @Parameter(property="trackPlugins")
    protected Boolean trackPlugins = Boolean.TRUE;
    @Parameter(property="licenseCheckBreakByUnknown")
    protected Boolean licenseCheckBreakByUnknown = Boolean.FALSE;
    @Parameter(property="skipScopes")
    protected String skipScopes = null;
    @Parameter(property="organisation")
    protected String organisation = null;
    @Parameter(property="team")
    protected String team = null;
    @Parameter(property="visibility")
    protected String visibility = null;
    @Parameter(property="name")
    protected String name = null;
    @Parameter(property="ignoreDependencyManagement")
    protected boolean ignoreDependencyManagement = false;
    protected Properties properties = null;
    protected Properties homeProperties = null;

    public void execute() throws MojoExecutionException, MojoFailureException {
    }

    protected String fetchApiKey() throws Exception {
        if (this.apiKey != null && !this.apiKey.isEmpty()) {
            return this.apiKey;
        }
        this.apiKey = System.getenv().get("VERSIONEYE_API_KEY");
        String propertiesPath = this.homeDirectory + "/.m2/" + propertiesFile;
        String key = this.getPropertyFromPath(propertiesPath, "api_key");
        if (key != null && !key.isEmpty()) {
            this.apiKey = key;
        }
        if ((key = this.getPropertyFromPath(propertiesPath = this.projectDirectory + "/src/qa/resources/" + propertiesFile, "api_key")) != null && !key.isEmpty()) {
            this.apiKey = key;
        }
        if ((key = this.getPropertyFromPath(propertiesPath = this.projectDirectory + "/src/main/resources/" + propertiesFile, "api_key")) != null && !key.isEmpty()) {
            this.apiKey = key;
        }
        return this.apiKey;
    }

    protected String fetchProjectId() throws Exception {
        if (this.projectId != null && !this.projectId.isEmpty()) {
            return this.projectId;
        }
        this.propertiesPath = this.projectDirectory + "/src/qa/resources/" + propertiesFile;
        String project_id = this.getPropertyFromPath(this.propertiesPath, "project_id");
        if (project_id != null && !project_id.isEmpty()) {
            this.projectId = project_id;
        }
        this.propertiesPath = this.projectDirectory + "/src/main/resources/" + propertiesFile;
        project_id = this.getPropertyFromPath(this.propertiesPath, "project_id");
        if (project_id != null && !project_id.isEmpty()) {
            this.projectId = project_id;
        }
        if (this.projectId == null || this.projectId.isEmpty()) {
            String msg = "versioneye.properties found but without project_id! Read the instructions at https://github.com/versioneye/versioneye_maven_plugin";
            this.getLog().error((CharSequence)msg);
            throw new MojoExecutionException(msg);
        }
        return this.projectId;
    }

    protected Properties fetchProjectProperties() throws Exception {
        if (this.properties != null) {
            return this.properties;
        }
        String propertiesPath = this.getPropertiesPath();
        File file = new File(propertiesPath);
        if (!file.exists()) {
            this.createPropertiesFile(file);
        }
        PropertiesUtils propertiesUtils = new PropertiesUtils();
        this.properties = propertiesUtils.readProperties(propertiesPath);
        return this.properties;
    }

    protected String getPropertiesPath() throws Exception {
        if (this.propertiesPath != null) {
            return this.propertiesPath;
        }
        String propertiesPath = this.projectDirectory + "/src/qa/resources/" + propertiesFile;
        File file = new File(propertiesPath);
        if (!file.exists()) {
            propertiesPath = this.projectDirectory + "/src/main/resources/" + propertiesFile;
            file = new File(propertiesPath);
        }
        if (!file.exists()) {
            propertiesPath = this.projectDirectory + "/src/qa/resources/" + propertiesFile;
        }
        this.propertiesPath = propertiesPath;
        return propertiesPath;
    }

    private void createPropertiesFile(File file) throws IOException {
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        file.createNewFile();
    }

    protected void initTls() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setProxy() {
        boolean emptyProxyPass;
        boolean emptyProxyPort;
        try {
            String propertiesPath;
            String host;
            if ((this.proxyHost == null || this.proxyHost.isEmpty()) && (host = this.getPropertyFromPath(propertiesPath = this.homeDirectory + "/.m2/" + propertiesFile, "proxyHost")) != null && !host.isEmpty()) {
                this.proxyHost = host;
            }
            if (this.proxyPort == null || this.proxyPort.isEmpty()) {
                this.propertiesPath = this.homeDirectory + "/.m2/" + propertiesFile;
                String port = this.getPropertyFromPath(this.propertiesPath, "proxyPort");
                if (port != null && !port.isEmpty()) {
                    this.proxyPort = port;
                }
            }
            if (this.proxyUser == null || this.proxyUser.isEmpty()) {
                this.propertiesPath = this.homeDirectory + "/.m2/" + propertiesFile;
                String user = this.getPropertyFromPath(this.propertiesPath, "proxyUser");
                if (user != null && !user.isEmpty()) {
                    this.proxyUser = user;
                }
            }
            if (this.proxyPassword == null || this.proxyPassword.isEmpty()) {
                this.propertiesPath = this.homeDirectory + "/.m2/" + propertiesFile;
                String password = this.getPropertyFromPath(this.propertiesPath, "proxyPassword");
                if (password != null && !password.isEmpty()) {
                    this.proxyPassword = password;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        boolean emptyProxyHost = this.proxyHost == null || this.proxyHost.isEmpty();
        boolean bl = emptyProxyPort = this.proxyPort == null || this.proxyPort.isEmpty();
        if (emptyProxyHost && emptyProxyPort) {
            return;
        }
        System.setProperty("proxySet", "true");
        System.setProperty("http.proxyHost", this.proxyHost);
        System.setProperty("http.proxyPort", this.proxyPort);
        System.setProperty("https.proxyHost", this.proxyHost);
        System.setProperty("https.proxyPort", this.proxyPort);
        boolean emptyProxyUser = this.proxyUser == null || this.proxyUser.isEmpty();
        boolean bl2 = emptyProxyPass = this.proxyPassword == null || this.proxyPassword.isEmpty();
        if (emptyProxyUser && emptyProxyPass) {
            return;
        }
        System.getProperties().put("http.proxyUser", this.proxyUser);
        System.getProperties().put("http.proxyPassword", this.proxyPassword);
    }

    private String getPropertyFromPath(String propertiesPath, String propertiesKey) throws Exception {
        File file = new File(propertiesPath);
        if (file.exists()) {
            PropertiesUtils propertiesUtils = new PropertiesUtils();
            Properties homeProperties = propertiesUtils.readProperties(propertiesPath);
            return homeProperties.getProperty(propertiesKey);
        }
        return null;
    }
}

