/*
 * Decompiled with CFR 0.152.
 */
package com.versioneye;

import com.versioneye.UpdateMojo;
import com.versioneye.dto.ProjectJsonResponse;
import java.io.ByteArrayOutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="securityAndLicenseCheck", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class SecurityAndLicenseCheckMojo
extends UpdateMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.setProxy();
            this.prettyPrintStart();
            ByteArrayOutputStream jsonDirectDependenciesStream = this.getDirectDependenciesJsonStream(this.nameStrategy);
            if (jsonDirectDependenciesStream == null) {
                this.prettyPrint0End();
                return;
            }
            ProjectJsonResponse response = this.uploadDependencies(jsonDirectDependenciesStream);
            System.out.println("sv_count: " + response.getSv_count());
            if (response.getSv_count() > 0) {
                throw new MojoExecutionException("Some components security vulnerabilities! More details here: " + this.baseUrl + "/user/projects/" + response.getId());
            }
            System.out.println("licenses_red: " + response.getLicenses_red());
            if (response.getLicenses_red() > 0) {
                throw new MojoExecutionException("Some components violate the license whitelist! More details here: " + this.baseUrl + "/user/projects/" + response.getId());
            }
            if (response.getLicenses_unknown() > 0 && this.licenseCheckBreakByUnknown.booleanValue()) {
                throw new MojoExecutionException("Some components are without any license! More details here: " + this.baseUrl + "/user/projects/" + response.getId());
            }
            this.prettyPrint(response);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MojoExecutionException("Oh no! Something went wrong. Get in touch with the VersionEye guys and give them feedback. You find them on Twitter at https//twitter.com/VersionEye. ", exception);
        }
    }
}

