/*
 * Decompiled with CFR 0.152.
 */
package com.versioneye;

import com.versioneye.ProjectMojo;
import com.versioneye.utils.DependencyUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="list", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class ListMojo
extends ProjectMojo {
    @Override
    public void execute() throws MojoExecutionException {
        this.versionEyeOutput();
        try {
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            DependencyNode root = this.getDependencyNode(nlg);
            List<Artifact> dependencies = DependencyUtils.collectAllDependencies(nlg.getDependencies(true));
            List<Artifact> directDependencies = DependencyUtils.collectDirectDependencies(root.getChildren());
            ArrayList<Artifact> recursiveDependencies = new ArrayList<Artifact>(dependencies);
            recursiveDependencies.removeAll(directDependencies);
            List deps = this.project.getDependencies();
            this.produceNiceOutput(deps, recursiveDependencies);
        }
        catch (Exception exception) {
            throw new MojoExecutionException("Oh no! Something went wrong. Get in touch with the VersionEye guys and give them feedback. You find them on Twitter at https//twitter.com/VersionEye. ", exception);
        }
    }

    private void produceNiceOutput(List<Dependency> directDependencies, List<Artifact> recursiveDependencies) {
        this.productNiceOutputForDirectDependencies(directDependencies);
        this.productNiceOutputForRecursiveDependencies(recursiveDependencies);
        this.produceNiceOutputSummary(directDependencies.size(), recursiveDependencies.size());
    }

    private void versionEyeOutput() {
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"************* \\_/ VersionEye \\_/ *************");
        this.getLog().info((CharSequence)"");
    }

    private void productNiceOutputForDirectDependencies(List<Dependency> directDependencies) {
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)(directDependencies.size() + " Direct Dependencies: "));
        this.getLog().info((CharSequence)"--------------------");
        for (Dependency dependency : directDependencies) {
            this.getLog().info((CharSequence)(dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion()));
        }
        this.getLog().info((CharSequence)"");
    }

    private void productNiceOutputForRecursiveDependencies(List<Artifact> recursiveDependencies) {
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)(recursiveDependencies.size() + " Transitive Dependencies: "));
        this.getLog().info((CharSequence)"--------------------");
        for (Artifact artifact : recursiveDependencies) {
            this.getLog().info((CharSequence)(artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion()));
        }
        this.getLog().info((CharSequence)"");
    }

    private void produceNiceOutputSummary(int directCount, int recursiveCount) {
        int allCount = directCount + recursiveCount;
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)(directCount + " Direct dependencies and " + recursiveCount + " transitive dependencies. This project has " + allCount + " dependencies."));
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"");
    }
}

