/*
 * Decompiled with CFR 0.152.
 */
package com.versioneye.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.maven.model.Dependency;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.aether.artifact.Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonUtils {
    public ByteArrayOutputStream dependenciesToJson(String name, List<Dependency> dependencies) throws Exception {
        List<Map<String, Object>> dependencyHashes = this.getDependencyHashes(dependencies);
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        JsonUtils.toJson(outstream, this.getJsonPom(name, dependencyHashes));
        return outstream;
    }

    public ByteArrayOutputStream artifactsToJson(List<Artifact> directDependencies) throws Exception {
        List<Map<String, Object>> hashes = this.getHashes(directDependencies);
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        JsonUtils.toJson(outstream, hashes);
        return outstream;
    }

    public void dependenciesToJsonFile(String name, List<Artifact> directDependencies, String file) throws Exception {
        List<Map<String, Object>> dependencyHashes = this.getHashes(directDependencies);
        File targetFile = new File(file);
        File parent = targetFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        JsonUtils.toJson(new FileOutputStream(targetFile), this.getJsonPom(name, dependencyHashes));
    }

    public static void toJson(OutputStream output, Object input) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue(output, input);
    }

    public List<Map<String, Object>> getHashes(List<Artifact> directDependencies) {
        Vector<Map<String, Object>> hashes = new Vector<Map<String, Object>>(directDependencies.size());
        hashes.addAll(JsonUtils.generateHashForJsonOutput(directDependencies));
        return hashes;
    }

    public List<Map<String, Object>> getDependencyHashes(List<Dependency> directDependencies) {
        Vector<Map<String, Object>> hashes = new Vector<Map<String, Object>>(directDependencies.size());
        hashes.addAll(JsonUtils.generateHashFromDependencyList(directDependencies));
        return hashes;
    }

    public static List<Map<String, Object>> generateHashForJsonOutput(List<Artifact> input) {
        Vector<Map<String, Object>> output = new Vector<Map<String, Object>>(input.size());
        for (Artifact artifact : input) {
            HashMap<String, String> hash = new HashMap<String, String>(2);
            hash.put("version", artifact.getVersion());
            hash.put("name", artifact.getGroupId() + ":" + artifact.getArtifactId());
            output.add(hash);
        }
        return output;
    }

    public static List<Map<String, Object>> generateHashFromDependencyList(List<Dependency> input) {
        Vector<Map<String, Object>> output = new Vector<Map<String, Object>>(input.size());
        for (Dependency dependency : input) {
            HashMap<String, String> hash = new HashMap<String, String>(2);
            hash.put("version", dependency.getVersion());
            hash.put("name", dependency.getGroupId() + ":" + dependency.getArtifactId());
            output.add(hash);
        }
        return output;
    }

    private Map<String, Object> getJsonPom(String name, List<Map<String, Object>> dependencyHashes) {
        HashMap<String, Object> pom = new HashMap<String, Object>();
        pom.put("name", name);
        pom.put("dependencies", dependencyHashes);
        return pom;
    }
}

