/*
 * Decompiled with CFR 0.152.
 */
package com.versioneye;

import com.versioneye.ProjectMojo;
import com.versioneye.dto.ProjectJsonResponse;
import com.versioneye.utils.HttpUtils;
import java.io.ByteArrayOutputStream;
import java.io.Reader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.jackson.map.ObjectMapper;

@Mojo(name="update", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class UpdateMojo
extends ProjectMojo {
    @Parameter(property="resource", defaultValue="/projects")
    private String resource;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.prettyPrintStart();
            ByteArrayOutputStream jsonDirectDependenciesStream = this.getDirectDependenciesJsonStream();
            ProjectJsonResponse response = this.uploadDependencies(jsonDirectDependenciesStream);
            this.writeProperties(response);
            this.prettyPrint(response);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MojoExecutionException("Oh no! Something went wrong. Get in touch with the VersionEye guys and give them feedback. You find them on Twitter at https//twitter.com/VersionEye. ", exception);
        }
    }

    private ProjectJsonResponse uploadDependencies(ByteArrayOutputStream outStream) throws Exception {
        String apiKey = this.fetchApiKey();
        String projectId = this.fetchProjectId();
        String url = this.baseUrl + this.apiPath + this.resource + "/" + projectId + "?api_key=" + apiKey;
        Reader reader = HttpUtils.post(url, outStream.toByteArray(), "project_file");
        ObjectMapper mapper = new ObjectMapper();
        return (ProjectJsonResponse)mapper.readValue(reader, ProjectJsonResponse.class);
    }

    private void prettyPrintStart() {
        this.getLog().info((CharSequence)".");
        this.getLog().info((CharSequence)"Starting to update dependencies to server. This can take a couple seconds ... ");
        this.getLog().info((CharSequence)".");
    }

    private void prettyPrint(ProjectJsonResponse response) throws Exception {
        this.getLog().info((CharSequence)".");
        this.getLog().info((CharSequence)("Dependencies: " + response.getDep_number()));
        this.getLog().info((CharSequence)("Outdated: " + response.getOut_number()));
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("You can find your updated project here: " + this.baseUrl + "/user/projects/" + response.getId()));
        this.getLog().info((CharSequence)"");
    }
}

