/*
 * Decompiled with CFR 0.152.
 */
package com.versioneye;

import com.versioneye.ProjectMojo;
import com.versioneye.utils.DependencyUtils;
import com.versioneye.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="json", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class JsonMojo
extends ProjectMojo {
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            DependencyNode root = this.getDependencyNode(nlg);
            List<Artifact> dependencies = DependencyUtils.collectAllDependencies(nlg.getDependencies(true));
            List<Artifact> directDependencies = DependencyUtils.collectDirectDependencies(root.getChildren());
            ArrayList<Artifact> recursiveDependencies = new ArrayList<Artifact>(dependencies);
            recursiveDependencies.removeAll(directDependencies);
            String pathToJson = this.writeToJson(directDependencies);
            this.prettyPrintEnd(pathToJson);
        }
        catch (Exception exception) {
            throw new MojoExecutionException("Oh no! Something went wrong. Get in touch with the VersionEye guys and give them feedback. You find them on Twitter at https//twitter.com/VersionEye. ", exception);
        }
    }

    private String writeToJson(List<Artifact> dependencies) throws Exception {
        JsonUtils jsonUtils = new JsonUtils();
        String filePath = this.outputDirectory + "/pom.json";
        jsonUtils.dependenciesToJsonFile(this.project.getName(), dependencies, filePath);
        return filePath;
    }

    private void prettyPrintEnd(String pathToJson) {
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("You find your json file here: " + pathToJson));
        this.getLog().info((CharSequence)"");
    }
}

